# Sistem Stok Otomatis Warung Bagas

## Overview
Sistem ini mengintegrasikan stok produk dengan bahan baku (inventory) menggunakan konsep BOM (Bill of Materials). Ketika admin menambah, mengedit, atau menghapus bahan baku, stok produk akan otomatis terupdate berdasarkan ketersediaan bahan baku.

## Cara Kerja Sistem

### 1. Struktur Database
- **Tabel `inventory`**: Menyimpan bahan baku (tepung, pengembang, cream, dll)
- **Tabel `bom_produk`**: Menyimpan hubungan antara bahan baku dan produk (berapa banyak bahan baku yang dibutuhkan untuk membuat 1 produk)
- **Tabel `produk`**: Menyimpan produk jadi yang dijual dengan field `stok` yang otomatis terupdate

### 2. Perhitungan Stok
Stok produk dihitung dengan rumus:
```
Stok Produk = MINIMUM(stok_bahan_1 / kebutuhan_bahan_1, stok_bahan_2 / kebutuhan_bahan_2, ...)
```

**Contoh:**
- Roti Sobek membutuhkan: 4kg tepung + 2kg pengembang + 3kg keju
- Stok tersedia: 76kg tepung, 0kg pengembang, 82kg keju
- Stok Roti Sobek = MIN(76/4, 0/2, 82/3) = MIN(19, 0, 27) = 0 unit

## Langkah-langkah Implementasi

### 1. Menjalankan Script SQL
Jalankan file-file SQL secara berurutan:

**a. Tambahkan field stok:**
```sql
-- Jalankan file: DATABASE/add_stok_field.sql
```

**b. Inisialisasi stok produk:**
```sql
-- Jalankan file: DATABASE/init_product_stock.sql
```

### 2. Akses Halaman Admin
1. Login ke admin panel
2. Buka menu "Data Transaksi" → "Inisialisasi Stok"
3. Klik tombol "Inisialisasi Stok Produk" untuk menghitung ulang stok

## Fitur yang Ditambahkan

### Halaman Admin
1. **Inventory Management** (`admin/inventory.php`)
   - ✅ Menambah bahan baku → stok produk otomatis terupdate
   - ✅ Mengedit bahan baku → stok produk otomatis terupdate  
   - ✅ Menghapus bahan baku → stok produk otomatis terupdate

2. **Inisialisasi Stok** (`admin/init_stock.php`)
   - ✅ Dashboard untuk melihat stok produk dan bahan baku
   - ✅ Tombol untuk menghitung ulang semua stok produk
   - ✅ Tabel detail hubungan bahan baku dan produk

### Halaman User
1. **Halaman Produk** (`produk.php`)
   - ✅ Menampilkan informasi stok real-time
   - ✅ Status stok dengan indikator warna
   - ✅ Tombol "Add to Cart" dinonaktifkan jika stok habis

2. **Halaman Detail Produk** (`detail_produk.php`)
   - ✅ Informasi stok di bagian atas halaman
   - ✅ Tombol "Add to Cart" dinonaktifkan jika stok habis

## File-file yang Dimodifikasi

### Database
- `DATABASE/add_stok_field.sql` - Menambah field stok ke tabel produk
- `DATABASE/init_product_stock.sql` - Script inisialisasi stok dengan fungsi MySQL

### Admin Panel
- `admin/helpers/stock_calculator.php` - Helper functions untuk perhitungan stok
- `admin/proses/tambah_inv.php` - Update stok produk saat tambah bahan baku
- `admin/proses/edit_inv.php` - Update stok produk saat edit bahan baku
- `admin/inventory.php` - Update stok produk saat hapus bahan baku
- `admin/init_stock.php` - Halaman dashboard stok
- `admin/header.php` - Menambah menu "Inisialisasi Stok"

### User Interface
- `produk.php` - Menampilkan informasi stok di product cards
- `detail_produk.php` - Menampilkan informasi stok di halaman detail

## Cara Penggunaan

### Untuk Admin:
1. **Menambah Bahan Baku:**
   - Buka menu "Data Transaksi" → "Inventory"
   - Klik "Tambah Barang"
   - Isi form dan submit
   - Stok produk akan otomatis terupdate

2. **Melihat Status Stok:**
   - Buka menu "Data Transaksi" → "Inisialisasi Stok"
   - Lihat tabel "Data Stok Produk" dan "Data Bahan Baku"
   - Klik "Inisialisasi Stok Produk" untuk menghitung ulang

### Untuk User:
1. **Melihat Stok Produk:**
   - Buka halaman produk
   - Setiap product card menampilkan informasi stok
   - Status: Tersedia (hijau), Terbatas (kuning), Habis (merah)

2. **Membeli Produk:**
   - Jika stok tersedia: tombol "Add to Cart" aktif
   - Jika stok habis: tombol "Out of Stock" (disabled)

## Keuntungan Sistem

1. **Real-time Updates**: Stok produk selalu akurat berdasarkan bahan baku tersedia
2. **Otomatis**: Tidak perlu manual update stok produk
3. **Transparan**: User bisa melihat status stok sebelum membeli
4. **Efisien**: Mencegah penjualan produk yang tidak bisa diproduksi
5. **Terintegrasi**: Menggunakan sistem BOM yang sudah ada

## Troubleshooting

### Jika stok tidak terupdate:
1. Pastikan data BOM sudah benar di tabel `bom_produk`
2. Pastikan bahan baku sudah ada di tabel `inventory`
3. Jalankan "Inisialisasi Stok Produk" di admin panel
4. Cek error log PHP untuk debugging

### Jika produk tidak muncul:
1. Pastikan field `stok` sudah ditambahkan ke tabel `produk`
2. Jalankan script SQL inisialisasi
3. Cek koneksi database 