<?php 
	include 'header.php';
 ?>

<style>
    body {
        background: linear-gradient(120deg, #f8fafc 0%, #e0e7ff 100%);
    }
    .about-main {
        display: flex;
        flex-wrap: wrap;
        align-items: center;
        justify-content: center;
        min-height: 80vh;
        gap: 40px;
        max-width: 1200px;
        margin: 60px auto 0 auto;
        padding: 0 20px;
    }
    .about-left {
        flex: 1 1 350px;
        background: rgba(255,255,255,0.97);
        border-radius: 18px;
        box-shadow: 0 8px 32px rgba(80,80,160,0.10);
        padding: 48px 40px 40px 40px;
        min-width: 320px;
        max-width: 540px;
    }
    .about-title {
        color: #ff8680;
        font-size: 2.5rem;
        font-weight: 700;
        margin-bottom: 18px;
        border-bottom: 4px solid #ff8680;
        padding-bottom: 8px;
    }
    .about-desc {
        color: #22223b;
        font-size: 1.15rem;
        line-height: 1.7;
        margin-bottom: 28px;
    }
    .about-features {
        display: flex;
        flex-wrap: wrap;
        gap: 18px 32px;
        margin-bottom: 10px;
    }
    .feature {
        display: flex;
        align-items: center;
        gap: 10px;
        font-size: 1.05rem;
        color: #444;
        background: #f8fafc;
        border-radius: 8px;
        padding: 7px 16px 7px 10px;
        box-shadow: 0 2px 8px rgba(80,80,160,0.04);
    }
    .feature-icon {
        font-size: 1.3rem;
        color: #ff8680;
    }
    .about-right {
        flex: 1 1 350px;
        display: flex;
        align-items: center;
        justify-content: center;
        min-width: 320px;
        max-width: 540px;
    }
    .about-img {
        width: 100%;
        max-width: 420px;
        border-radius: 22px;
        box-shadow: 0 8px 32px rgba(80,80,160,0.13);
        object-fit: cover;
        background: #eee;
    }
    @media (max-width: 900px) {
        .about-main { flex-direction: column; gap: 32px; }
        .about-left, .about-right { max-width: 100%; }
    }
</style>

<div class="about-main">
    <div class="about-left">
        <div class="about-title">Tentang Warung Bagas</div>
        <div class="about-desc">
            WARUNG BAGAS berdiri sejak tahun 2019 sebagai usaha keluarga yang melayani kebutuhan sembako harian masyarakat sekitar. Sejak awal, kami berkomitmen menyediakan berbagai kebutuhan pokok dengan harga terjangkau, produk yang selalu segar, dan pelayanan yang ramah.<br><br>
            Berlokasi di Bekasi, Warung Bagas melayani pelanggan dari berbagai kalangan—mulai dari ibu rumah tangga, pekerja, hingga pelaku usaha kecil. Kami menyediakan berbagai produk seperti beras, minyak goreng, gula, telur, mie instan, hingga kebutuhan rumah tangga lainnya.<br><br>
            Dengan pengalaman lebih dari 5 tahun, kami terus berkembang mengikuti kebutuhan pelanggan dan perkembangan zaman. Kini, Warung Bagas juga mulai melayani pemesanan melalui pesan singkat dan platform online untuk memudahkan akses belanja sembako tanpa harus keluar rumah.
        </div>
        <div class="about-features">
            <div class="feature"><span class="feature-icon">💰</span>Harga Terjangkau</div>
            <div class="feature"><span class="feature-icon">🥚</span>Produk Selalu Segar</div>
            <div class="feature"><span class="feature-icon">🤝</span>Pelayanan Ramah</div>
            <div class="feature"><span class="feature-icon">🕒</span>Buka 24 Jam</div>
            <div class="feature"><span class="feature-icon">📦</span>Pemesanan Online</div>
        </div>
    </div>
    <div class="about-right">
        <img src="image/home/footer.jpg" alt="Warung Bagas" class="about-img" onerror="this.src='https://via.placeholder.com/420x320?text=Warung+Bagas';">
    </div>
</div>


 <?php 
	include 'footer.php';
 ?>