<?php 
include 'header.php';
// pesanan baru 
$result1 = mysqli_query($conn, "SELECT distinct invoice FROM produksi WHERE terima = 0 and tolak = 0");
$jml1 = mysqli_num_rows($result1);

// pesanan dibatalkan/ditolak
$result2 = mysqli_query($conn, "SELECT distinct invoice FROM produksi WHERE  tolak = 1");
$jml2 = mysqli_num_rows($result2);

// pesanan diterima
$result3 = mysqli_query($conn, "SELECT distinct invoice FROM produksi WHERE  terima = 1");
$jml3 = mysqli_num_rows($result3);
?>

<style>
    * {
        box-sizing: border-box;
    }
    
    .dashboard-container {
        min-height: 100vh;
        background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
        padding: 3rem 1rem;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }
    
    .dashboard-header {
        text-align: center;
        margin-bottom: 3rem;
    }
    
    .dashboard-title {
        font-size: 2.5rem;
        font-weight: 700;
        color: #1e293b;
        margin-bottom: 0.5rem;
        letter-spacing: -0.025em;
    }
    
    .dashboard-subtitle {
        font-size: 1.125rem;
        color: #64748b;
        font-weight: 500;
    }
    
    .stats-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
        gap: 2rem;
        max-width: 1200px;
        margin: 0 auto;
    }
    
    .stat-card {
        background: white;
        border-radius: 20px;
        padding: 2.5rem;
        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.08);
        transition: all 0.3s ease;
        position: relative;
        overflow: hidden;
    }
    
    .stat-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 5px;
        background: var(--accent-color);
    }
    
    .stat-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 20px 40px rgba(0, 0, 0, 0.12);
    }
    
    .stat-card.new {
        --accent-color: linear-gradient(135deg, #3b82f6 0%, #1d4ed8 100%);
    }
    
    .stat-card.cancelled {
        --accent-color: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);
    }
    
    .stat-card.accepted {
        --accent-color: linear-gradient(135deg, #10b981 0%, #059669 100%);
    }
    
    .stat-header {
        display: flex;
        align-items: center;
        margin-bottom: 1.5rem;
    }
    
    .stat-icon {
        width: 60px;
        height: 60px;
        border-radius: 16px;
        display: flex;
        align-items: center;
        justify-content: center;
        margin-right: 1rem;
        font-size: 1.5rem;
        color: white;
    }
    
    .stat-card.new .stat-icon {
        background: linear-gradient(135deg, #3b82f6 0%, #1d4ed8 100%);
    }
    
    .stat-card.cancelled .stat-icon {
        background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);
    }
    
    .stat-card.accepted .stat-icon {
        background: linear-gradient(135deg, #10b981 0%, #059669 100%);
    }
    
    .stat-title {
        font-size: 1.125rem;
        font-weight: 600;
        color: #374151;
        margin: 0;
        text-transform: uppercase;
        letter-spacing: 0.05em;
    }
    
    .stat-number {
        font-size: 4rem;
        font-weight: 800;
        color: #1e293b;
        margin: 0;
        line-height: 1;
        background: linear-gradient(135deg, #1e293b 0%, #475569 100%);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        background-clip: text;
    }
    
    .stat-description {
        font-size: 0.875rem;
        color: #6b7280;
        margin-top: 0.5rem;
        font-weight: 500;
    }
    
    .dashboard-footer {
        text-align: center;
        margin-top: 4rem;
        padding-top: 2rem;
        border-top: 1px solid #e5e7eb;
    }
    
    .footer-text {
        color: #9ca3af;
        font-size: 0.875rem;
    }
    
    @media (max-width: 768px) {
        .dashboard-container {
            padding: 2rem 1rem;
        }
        
        .dashboard-title {
            font-size: 2rem;
        }
        
        .stats-grid {
            grid-template-columns: 1fr;
            gap: 1.5rem;
        }
        
        .stat-card {
            padding: 2rem 1.5rem;
        }
        
        .stat-number {
            font-size: 3rem;
        }
        
        .stat-icon {
            width: 50px;
            height: 50px;
            font-size: 1.25rem;
        }
    }
    
    @media (max-width: 480px) {
        .stat-header {
            flex-direction: column;
            text-align: center;
        }
        
        .stat-icon {
            margin-right: 0;
            margin-bottom: 1rem;
        }
        
        .stat-number {
            font-size: 2.5rem;
        }
    }
</style>

<div class="dashboard-container">
    <div class="dashboard-header">
        <h1 class="dashboard-title">Dashboard Pesanan</h1>
        <p class="dashboard-subtitle">Monitoring status pesanan secara real-time</p>
    </div>
    
    <div class="stats-grid">
        <div class="stat-card new">
            <div class="stat-header">
                <div class="stat-icon">
                    <i class="fas fa-clock"></i>
                </div>
                <div>
                    <h3 class="stat-title">Pesanan Baru</h3>
                    <p class="stat-description">Menunggu konfirmasi</p>
                </div>
            </div>
            <p class="stat-number"><?= $jml1; ?></p>
        </div>
        
        <div class="stat-card cancelled">
            <div class="stat-header">
                <div class="stat-icon">
                    <i class="fas fa-times-circle"></i>
                </div>
                <div>
                    <h3 class="stat-title">Pesanan Dibatalkan</h3>
                    <p class="stat-description">Tidak dapat diproses</p>
                </div>
            </div>
            <p class="stat-number"><?= $jml2; ?></p>
        </div>
        
        <div class="stat-card accepted">
            <div class="stat-header">
                <div class="stat-icon">
                    <i class="fas fa-check-circle"></i>
                </div>
                <div>
                    <h3 class="stat-title">Pesanan Diterima</h3>
                    <p class="stat-description">Berhasil diproses</p>
                </div>
            </div>
            <p class="stat-number"><?= $jml3; ?></p>
        </div>
    </div>
    
    <div class="dashboard-footer">
        <p class="footer-text">Data diperbarui secara otomatis</p>
    </div>
</div>

<?php 
include 'footer.php';
?>