<?php 
include 'header.php';
include 'helpers/stock_calculator.php';

// Proses inisialisasi stok
if(isset($_POST['init_stock'])) {
	updateAllProductStocks($conn);
	$success_message = "Stok semua produk berhasil diperbarui berdasarkan bahan baku yang tersedia!";
}

// Ambil data produk dengan stok
$products_query = "SELECT p.*, 
				   GROUP_CONCAT(CONCAT(bp.kode_bk, ':', bp.kebutuhan, ' (', COALESCE(i.qty, 0), ')') SEPARATOR ', ') as bahan_baku
				   FROM produk p
				   LEFT JOIN bom_produk bp ON p.kode_produk = bp.kode_produk
				   LEFT JOIN inventory i ON bp.kode_bk = i.kode_bk
				   GROUP BY p.kode_produk, p.nama, p.harga, p.stok
				   ORDER BY p.kode_produk";
$products_result = mysqli_query($conn, $products_query);
?>

<div class="container">
	<h2 style="width: 100%; border-bottom: 4px solid gray"><b>Inisialisasi Stok Produk</b></h2>
	
	<?php if(isset($success_message)): ?>
		<div class="alert alert-success">
			<strong>Berhasil!</strong> <?= $success_message; ?>
		</div>
	<?php endif; ?>
	
	<div class="row">
		<div class="col-md-12">
			<div class="panel panel-info">
				<div class="panel-heading">
					<h3 class="panel-title">Informasi Sistem Stok</h3>
				</div>
				<div class="panel-body">
					<p><strong>Cara Kerja:</strong></p>
					<ul>
						<li>Sistem akan menghitung stok produk berdasarkan ketersediaan bahan baku</li>
						<li>Stok produk = minimum dari (stok bahan baku / kebutuhan bahan baku per produk)</li>
						<li>Ketika admin menambah/edit/hapus bahan baku, stok produk akan otomatis terupdate</li>
						<li>Stok produk di halaman user akan menampilkan informasi real-time</li>
					</ul>
					
					<form method="POST" style="margin-top: 20px;">
						<button type="submit" name="init_stock" class="btn btn-primary" onclick="return confirm('Yakin ingin menginisialisasi ulang stok semua produk?')">
							<i class="glyphicon glyphicon-refresh"></i> Inisialisasi Stok Produk
						</button>
					</form>
				</div>
			</div>
		</div>
	</div>
	
	<div class="row">
		<div class="col-md-12">
			<div class="panel panel-default">
				<div class="panel-heading">
					<h3 class="panel-title">Data Stok Produk</h3>
				</div>
				<div class="panel-body">
					<table class="table table-striped table-bordered">
						<thead>
							<tr>
								<th>Kode Produk</th>
								<th>Nama Produk</th>
								<th>Harga</th>
								<th>Stok</th>
								<th>Status</th>
								<th>Bahan Baku (Kebutuhan: Stok Tersedia)</th>
							</tr>
						</thead>
						<tbody>
							<?php while($product = mysqli_fetch_assoc($products_result)): ?>
								<?php $stock_status = getProductStockStatus($product['stok']); ?>
								<tr>
									<td><?= $product['kode_produk']; ?></td>
									<td><?= $product['nama']; ?></td>
									<td>Rp<?= number_format($product['harga']); ?></td>
									<td>
										<span class="badge badge-<?= $stock_status['color']; ?>">
											<?= $product['stok']; ?> unit
										</span>
									</td>
									<td>
										<span class="label label-<?= $stock_status['color']; ?>">
											<?= $stock_status['status']; ?>
										</span>
									</td>
									<td>
										<small><?= $product['bahan_baku'] ?: 'Tidak ada data BOM'; ?></small>
									</td>
								</tr>
							<?php endwhile; ?>
						</tbody>
					</table>
				</div>
			</div>
		</div>
	</div>
	
	<div class="row">
		<div class="col-md-12">
			<div class="panel panel-warning">
				<div class="panel-heading">
					<h3 class="panel-title">Data Bahan Baku</h3>
				</div>
				<div class="panel-body">
					<table class="table table-striped table-bordered">
						<thead>
							<tr>
								<th>Kode Bahan</th>
								<th>Nama Bahan</th>
								<th>Stok</th>
								<th>Satuan</th>
								<th>Harga</th>
								<th>Produk yang Menggunakan</th>
							</tr>
						</thead>
						<tbody>
							<?php 
							$inventory_query = "SELECT i.*, 
											   GROUP_CONCAT(DISTINCT bp.nama_produk SEPARATOR ', ') as produk_terkait
											   FROM inventory i
											   LEFT JOIN bom_produk bp ON i.kode_bk = bp.kode_bk
											   GROUP BY i.kode_bk, i.nama, i.qty, i.satuan, i.harga
											   ORDER BY i.kode_bk";
							$inventory_result = mysqli_query($conn, $inventory_query);
							while($inventory = mysqli_fetch_assoc($inventory_result)): 
							?>
								<tr>
									<td><?= $inventory['kode_bk']; ?></td>
									<td><?= $inventory['nama']; ?></td>
									<td>
										<span class="badge badge-<?= $inventory['qty'] > 0 ? 'success' : 'danger'; ?>">
											<?= $inventory['qty']; ?> <?= $inventory['satuan']; ?>
										</span>
									</td>
									<td><?= $inventory['satuan']; ?></td>
									<td>Rp<?= number_format($inventory['harga']); ?>/<?= $inventory['satuan']; ?></td>
									<td>
										<small><?= $inventory['produk_terkait'] ?: 'Tidak digunakan'; ?></small>
									</td>
								</tr>
							<?php endwhile; ?>
						</tbody>
					</table>
				</div>
			</div>
		</div>
	</div>
</div>

<style>
.badge-success {
	background-color: #5cb85c;
}

.badge-warning {
	background-color: #f0ad4e;
}

.badge-danger {
	background-color: #d9534f;
}

.label-success {
	background-color: #5cb85c;
}

.label-warning {
	background-color: #f0ad4e;
}

.label-danger {
	background-color: #d9534f;
}
</style>

<?php 
include 'footer.php';
?> 