<?php 
function tgl_indo($tanggal) {
    if(!$tanggal || $tanggal == '-') return '-';
    $bulan = [
        1 => 'Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni',
        'Juli', 'Agustus', 'September', 'Oktober', 'November', 'Desember'
    ];
    $pecah = explode('-', substr($tanggal,0,10));
    if(count($pecah) == 3) {
        return (int)$pecah[2] . ' ' . $bulan[(int)$pecah[1]] . ' ' . $pecah[0];
    } else {
        return $tanggal;
    }
}
include 'header.php';
$sortage = mysqli_query($conn, "SELECT * FROM produksi where cek = '1'");
$cek_sor = mysqli_num_rows($sortage);
$nama_material = [];
?>

<div class="container">
	<h2 style=" width: 100%; border-bottom: 4px solid gray"><b>Daftar Pesanan</b></h2>
	<br>
	<h5 class="bg-success" style="padding: 7px; width: 710px; font-weight: bold;"><marquee>Lakukan Reload Setiap Masuk Halaman ini, untuk menghindari terjadinya kesalahan data dan informasi</marquee></h5>
	<a href="produksi.php" class="btn btn-default"><i class="glyphicon glyphicon-refresh"></i> Reload</a>
	<br>
	<table class="table table-striped">
		<thead>
			<tr>
				<th>No</th>
				<th>Invoice</th>
				<th>Kode Customer</th>
				<th>Status</th>
				<th>Tanggal</th>
				<th>Bukti Pembayaran</th>
				<th>Action</th>
			</tr>
		</thead>
		<tbody>
			<?php 
			$result = mysqli_query($conn, "SELECT p.invoice, p.kode_customer, p.status, p.terima, p.tolak, p.cek, c.bukti, p.tanggal 
    FROM produksi p 
    INNER JOIN (SELECT invoice, MIN(id_order) as min_id FROM produksi GROUP BY invoice) as x ON p.invoice = x.invoice AND p.id_order = x.min_id 
    LEFT JOIN checkout c ON c.invoice = p.invoice");
			$no = 1;
			$array = 0;
			while($row = mysqli_fetch_assoc($result)){
				$kodep = isset($row['kode_produk']) ? $row['kode_produk'] : '';
				$inv = $row['invoice'];
			?>
				<tr>
					<td><?= $no; ?></td>
					<td><?= $row['invoice']; ?></td>
					<td><?= $row['kode_customer']; ?></td>
					
					<?php if($row['terima'] == 1){ ?>
						<td style="color: green;font-weight: bold;">Pesanan Diterima (Siap Kirim)</td>
					<?php } else if($row['tolak'] == 1){ ?>
						<td style="color: red;font-weight: bold;">Pesanan Ditolak</td>
					<?php } else { ?>
						<td style="color: orange;font-weight: bold;"><?= $row['status']; ?></td>
					<?php } ?>

					<td><?= isset($row['tanggal']) ? tgl_indo($row['tanggal']) : '-'; ?></td>

					<!-- BUKTI PEMBAYARAN -->
<td>
    <?php if(!empty($row['bukti'])): ?>
        <a href="../bukti/<?= $row['bukti']; ?>" target="_blank">
            <img src="../bukti/<?= $row['bukti']; ?>" width="50" style="border-radius: 5px;">
        </a>
    <?php else: ?>
        <span style="color: gray;">Belum Upload</span>
    <?php endif; ?>
</td>


					<td>
						<!-- Hapus seluruh kode terkait bom_produk dan inventory, hanya tampilkan tombol konfirmasi pesanan, detail, dan hapus -->
						<?php if( $row['tolak']==0 && $row['cek']==1 && $row['terima']==0){ ?>
							<a href="#" class="btn btn-warning disabled"><i class="glyphicon glyphicon-warning-sign"></i> Material Shortage (Nonaktif)</a> 
							<a href="proses/tolak.php?inv=<?= $row['invoice']; ?>" class="btn btn-danger" onclick="return confirm('Yakin Ingin Menolak ?')"><i class="glyphicon glyphicon-remove-sign"></i> Tolak</a> 
						<?php } else if($row['terima'] == 0 && $row['cek']==0){ ?>
							<a href="proses/terima.php?inv=<?= $row['invoice']; ?>" class="btn btn-success"><i class="glyphicon glyphicon-ok-sign"></i> Terima</a> 
							<a href="proses/tolak.php?inv=<?= $row['invoice']; ?>" class="btn btn-danger" onclick="return confirm('Yakin Ingin Menolak ?')"><i class="glyphicon glyphicon-remove-sign"></i> Tolak</a> 
						<?php } ?>
						<a href="detailorder.php?inv=<?= $row['invoice']; ?>&cs=<?= $row['kode_customer']; ?>" type="submit" class="btn btn-primary"><i class="glyphicon glyphicon-eye-open"></i> Detail Pesanan</a>
						<a href="../proses/hapus_pesanan.php?inv=<?= $row['invoice']; ?>" class="btn btn-danger" onclick="return confirm('Yakin ingin menghapus pesanan ini?')"><i class="glyphicon glyphicon-trash"></i> Hapus</a>
					</td>
				</tr>
			<?php
				$no++; 
			}
			?>
		</tbody>
	</table>

	<?php if($cek_sor > 0): ?>
		<br><br>
		<div class="row">
			<div class="col-md-4 bg-danger" style="padding:10px;">
				<h4>Kekurangan Barang </h4>
				<h5 style="color: red;font-weight: bold;">Silahkan Tambah Stok Barang dibawah ini : </h5>
				<table class="table table-striped">
					<tr>
						<th>No</th>
						<th>Barang</th>
					</tr>
					<?php 
					$arr = array_values(array_unique(is_array($nama_material) ? $nama_material : []));
					for ($i=0; $i < count($arr); $i++) { 
					?>
					<tr>
						<td><?= $i+1 ?></td>
						<td><?= $arr[$i]; ?></td>
					</tr>
					<?php } ?>
				</table>
			</div>
		</div>
	<?php endif; ?>

</div>

<br><br><br><br><br><br><br><br><br><br><br><br>

<?php 
include 'footer.php';
?>
