<?php 
include 'header.php';
if (isset($_GET['kode_cs']) && !empty($_GET['kode_cs'])) {
    $kd = mysqli_real_escape_string($conn, $_GET['kode_cs']);
} elseif (isset($_SESSION['kd_cs'])) {
    $kd = mysqli_real_escape_string($conn, $_SESSION['kd_cs']);
} else {
    $kd = '';
}
$rows = [];
if (!empty($kd)) {
    $cs = mysqli_query($conn, "SELECT * FROM customer WHERE kode_customer = '$kd'");
    $rows = mysqli_fetch_assoc($cs);
}
?>

<style>
    * {
        box-sizing: border-box;
    }
    
    .checkout-container {
        max-width: 1200px;
        margin: 0 auto;
        padding: 2rem 1rem;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        background: #f8fafc;
        min-height: 100vh;
    }
    
    .checkout-header {
        text-align: center;
        margin-bottom: 3rem;
        padding-bottom: 1rem;
        border-bottom: 2px solid #e2e8f0;
    }
    
    .checkout-title {
        font-size: 2.5rem;
        font-weight: 700;
        color: #1e293b;
        margin: 0;
        letter-spacing: -0.025em;
    }
    
    .checkout-grid {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 2rem;
        margin-bottom: 3rem;
    }
    
    .card {
        background: white;
        border-radius: 16px;
        box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
        overflow: hidden;
        transition: transform 0.2s ease, box-shadow 0.2s ease;
    }
    
    .card:hover {
        transform: translateY(-2px);
        box-shadow: 0 8px 25px -5px rgba(0, 0, 0, 0.1);
    }
    
    .card-header {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        padding: 1.5rem;
        font-size: 1.25rem;
        font-weight: 600;
    }
    
    .card-body {
        padding: 1.5rem;
    }
    
    .order-table {
        width: 100%;
        border-collapse: collapse;
        margin-bottom: 1rem;
    }
    
    .order-table th {
        background: #f1f5f9;
        color: #475569;
        padding: 0.75rem;
        text-align: left;
        font-weight: 600;
        font-size: 0.875rem;
        text-transform: uppercase;
        letter-spacing: 0.05em;
        border-bottom: 2px solid #e2e8f0;
    }
    
    .order-table td {
        padding: 0.75rem;
        border-bottom: 1px solid #e2e8f0;
        color: #64748b;
    }
    
    .order-table tbody tr:hover {
        background: #f8fafc;
    }
    
    .grand-total {
        background: linear-gradient(135deg, #10b981 0%, #059669 100%);
        color: white !important;
        font-weight: 700;
        font-size: 1.1rem;
    }
    
    .bank-grid {
        display: grid;
        grid-template-columns: repeat(2, 1fr);
        gap: 1rem;
        margin-top: 1rem;
    }
    
    .bank-item {
        display: flex;
        align-items: center;
        justify-content: space-between;
        padding: 1rem;
        background: #f8fafc;
        border: 2px solid #e2e8f0;
        border-radius: 12px;
        transition: all 0.2s ease;
    }
    
    .bank-item:hover {
        border-color: #667eea;
        transform: translateY(-1px);
    }
    
    .bank-logo {
        width: 40px;
        height: 40px;
        object-fit: contain;
    }
    
    .bank-number {
        font-weight: 600;
        color: #dc2626;
        font-family: 'Courier New', monospace;
    }
    
    .form-container {
        background: white;
        border-radius: 16px;
        box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
        padding: 2rem;
        margin-top: 2rem;
    }
    
    .alert {
        padding: 1rem 1.5rem;
        border-radius: 12px;
        margin-bottom: 1rem;
        font-weight: 500;
        border: none;
    }
    
    .alert-success {
        background: linear-gradient(135deg, #10b981 0%, #059669 100%);
        color: white;
    }
    
    .alert-warning {
        background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%);
        color: white;
    }
    
    .form-group {
        margin-bottom: 1.5rem;
    }
    
    .form-label {
        display: block;
        margin-bottom: 0.5rem;
        font-weight: 600;
        color: #374151;
        font-size: 0.875rem;
        text-transform: uppercase;
        letter-spacing: 0.05em;
    }
    
    .form-control {
        width: 100%;
        padding: 0.75rem 1rem;
        border: 2px solid #e5e7eb;
        border-radius: 8px;
        font-size: 1rem;
        transition: all 0.2s ease;
        background: white;
        resize: vertical;
    }
    
    .form-control:focus {
        outline: none;
        border-color: #667eea;
        box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
    }
    
    .form-control:read-only {
        background: #f9fafb;
        color: #6b7280;
    }
    
    .form-control.textarea {
        min-height: 100px;
    }
    
    .form-row {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 1rem;
    }
    
    .form-section {
        background: #f8fafc;
        padding: 1.5rem;
        border-radius: 12px;
        margin-bottom: 2rem;
        border: 1px solid #e2e8f0;
    }
    
    .form-section-title {
        font-size: 1.1rem;
        font-weight: 600;
        color: #1e293b;
        margin-bottom: 1.5rem;
        padding-bottom: 0.5rem;
        border-bottom: 2px solid #e2e8f0;
    }
    
    .btn {
        padding: 0.75rem 2rem;
        border-radius: 8px;
        font-weight: 600;
        text-decoration: none;
        display: inline-flex;
        align-items: center;
        gap: 0.5rem;
        transition: all 0.2s ease;
        border: none;
        cursor: pointer;
        font-size: 1rem;
    }
    
    .btn-success {
        background: linear-gradient(135deg, #10b981 0%, #059669 100%);
        color: white;
    }
    
    .btn-success:hover {
        transform: translateY(-2px);
        box-shadow: 0 8px 25px -5px rgba(16, 185, 129, 0.3);
    }
    
    .btn-danger {
        background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);
        color: white;
    }
    
    .btn-danger:hover {
        transform: translateY(-2px);
        box-shadow: 0 8px 25px -5px rgba(239, 68, 68, 0.3);
    }
    
    .btn-container {
        display: flex;
        gap: 1rem;
        justify-content: flex-end;
        margin-top: 2rem;
    }
    
    @media (max-width: 768px) {
        .checkout-grid {
            grid-template-columns: 1fr !important;
            gap: 1rem !important;
        }
        .form-row {
            grid-template-columns: 1fr !important;
        }
        .bank-grid {
            grid-template-columns: 1fr !important;
        }
        .btn-container {
            flex-direction: column !important;
        }
        .checkout-title {
            font-size: 2rem !important;
        }
        .card, .form-container {
            padding: 1rem !important;
        }
    }

    .bank-info {
        display: flex;
        flex-direction: column;
        justify-content: center;
    }
    .bank-number {
        font-weight: 700;
        color: #dc2626;
        font-family: 'Courier New', monospace;
        font-size: 1.1rem;
        line-height: 1.2;
    }
    .bank-owner {
        font-weight: 500;
        color: #222;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        font-size: 1rem;
        margin-top: 2px;
    }
</style>

<div class="checkout-container">
    <div class="checkout-header">
        <h1 class="checkout-title">Checkout</h1>
    </div>

    <div class="checkout-grid">
        <!-- Daftar Pesanan -->
        <div class="card">
            <div class="card-header">
                <i class="fas fa-shopping-cart"></i> Daftar Pesanan
            </div>
            <div class="card-body">
                <table class="order-table">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Nama</th>
                            <th>Harga</th>
                            <th>Qty</th>
                            <th>Sub Total</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php 
                        $result = mysqli_query($conn, "SELECT * FROM keranjang WHERE kode_customer = '$kd'");
                        $no = 1;
                        $hasil = 0;
                        while($row = mysqli_fetch_assoc($result)) {
                            $total = $row['harga'] * $row['qty'];
                            $hasil += $total;
                        ?>
                        <tr>
                            <td><?= $no++; ?></td>
                            <td><?= $row['nama_produk']; ?></td>
                            <td>Rp.<?= number_format($row['harga']); ?></td>
                            <td><?= $row['qty']; ?></td>
                            <td>Rp.<?= number_format($total); ?></td>
                        </tr>
                        <?php } ?>
                    </tbody>
                    <tfoot>
                        <tr>
                            <td colspan="5" class="grand-total">Grand Total = Rp.<?= number_format($hasil); ?></td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>

        <!-- Rekening Toko Roti -->
        <div class="card">
            <div class="card-header">
                <i class="fas fa-university"></i> Rekening Toko Roti
            </div>
            <div class="card-body">
                <div class="bank-grid">
                    <div class="bank-item">
                        <img src="/wargas/image/rek/DANA.png" alt="DANA" class="bank-logo">
                        <div class="bank-info">
                            <span class="bank-number">0812-9689-9031</span>
                            <span class="bank-owner">a/n Muhammad Bagas Saputra</span>
                        </div>
                    </div>
                    <div class="bank-item">
                        <img src="/wargas/image/rek/GOPAY.PNG" alt="GOPAY" class="bank-logo">
                        <div class="bank-info">
                            <span class="bank-number">0812-9689-9031</span>
                            <span class="bank-owner">a/n Muhammad Bagas Saputra</span>
                        </div>
                    </div>
                    <div class="bank-item">
                        <img src="/wargas/image/rek/OVO.png" alt="OVO" class="bank-logo">
                        <div class="bank-info">
                            <span class="bank-number">0812-9689-9031</span>
                            <span class="bank-owner">a/n Muhammad Bagas Saputra</span>
                        </div>
                    </div>
                    <div class="bank-item">
                        <img src="/wargas/image/rek/SPAY.jpg" alt="SHOPEEPAY" class="bank-logo">
                        <div class="bank-info">
                            <span class="bank-number">0812-9689-9031</span>
                            <span class="bank-owner">a/n Muhammad Bagas Saputra</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="form-container">
        <div class="alert alert-success">
            <i class="fas fa-check-circle"></i> Pastikan Pesanan Anda Sudah Benar
        </div>
        
        <div class="alert alert-warning">
            <i class="fas fa-edit"></i> Isi Form di bawah ini
        </div>

        <form action="proses/order.php" method="POST" enctype="multipart/form-data">
            <input type="hidden" name="kode_cs" value="<?= $kd; ?>">

            <!-- Informasi Personal -->
            <div class="form-section">
                <h3 class="form-section-title">
                    <i class="fas fa-user"></i> Informasi Personal
                </h3>
                
                <div class="form-group">
                    <label class="form-label" for="nama">Nama Lengkap</label>
                    <input type="text" class="form-control" name="nama" value="<?= isset($rows['nama']) ? $rows['nama'] : ''; ?>" readonly>
                </div>
            </div>

            <!-- Informasi Alamat -->
            <div class="form-section">
                <h3 class="form-section-title">
                    <i class="fas fa-map-marker-alt"></i> Informasi Alamat Pengiriman
                </h3>
                <div class="form-row">
                    <div class="form-group">
                        <label class="form-label" for="rt">RT</label>
                        <input type="text" id="rt" name="rt" class="form-control" placeholder="003" maxlength="3" required>
                    </div>
                    <div class="form-group">
                        <label class="form-label" for="rw">RW</label>
                        <input type="text" id="rw" name="rw" class="form-control" placeholder="007" maxlength="3" required>
                    </div>
                </div>
                <div class="form-group">
                    <label class="form-label" for="alamat_lengkap">Alamat Lengkap (Nama Jalan, No Rumah, Patokan, dll)</label>
                    <textarea name="alamat_lengkap" id="alamat_lengkap" class="form-control textarea" placeholder="Contoh: Jl. Melati No. 10, dekat pos ronda" required></textarea>
                </div>
                <div class="form-group">
                    <label class="form-label" for="no_telepon">No. Telepon</label>
                    <input type="tel" id="no_telepon" name="no_telepon" class="form-control" placeholder="08xxxxxxxxxx" required>
                </div>
                <div class="form-group">
                    <label class="form-label" for="jam_pengantaran">Jam Pengantaran</label>
                    <select id="jam_pengantaran" name="jam_pengantaran" class="form-control" required>
                        <option hidden>-Pilih Jam Pengantaran-</option>
                        <option>07.00 - 08.00</option>
                        <option>08.00 - 09.00</option>
                        <option>09.00 - 10.00</option>
                        <option>10.00 - 11.00</option>
                        <option>11.00 - 12.00</option>
                        <option>12.00 - 13.00</option>
                        <option>13.00 - 14.00</option>
                        <option>14.00 - 15.00</option>
                        <option>15.00 - 16.00</option>
                        <option>16.00 - 17.00</option>
                    </select>
                    <small style="color:#888;">Batas waktu pengantaran maksimal jam 17.00 WIB</small>
                </div>
            </div>

            <!-- Informasi Pembayaran -->
            <div class="form-section">
                <h3 class="form-section-title">
                    <i class="fas fa-credit-card"></i> Informasi Pembayaran
                </h3>
                
                <div class="form-group">
                    <label class="form-label">Bank</label>
                    <select name="txtbank" class="form-control" required>
                        <option hidden>-Pilih Bank-</option>
                        <option>DANA</option>
                        <option>SHOPEEPAY</option>
                        <option>OVO</option>
                        <option>GOPAY</option>
                    </select>
                </div>

                <div class="form-row">
                    <div class="form-group">
                        <label class="form-label">No. Rekening</label>
                        <input type="text" class="form-control" name="txtnorek" 
                               placeholder="Masukkan nomor rekening Anda" required>
                    </div>
                    <div class="form-group">
                        <label class="form-label">Nama Pemilik Rekening</label>
                        <input type="text" class="form-control" name="txtnamarek" 
                               placeholder="Nama sesuai rekening" required>
                    </div>
                </div>

                <div class="form-group">
                    <label class="form-label">Upload Bukti Transfer</label>
                    <input type="file" class="form-control" name="txtgambar" accept="image/*" required>
                </div>
            </div>

            <div class="btn-container">
                <a href="keranjang.php" class="btn btn-danger">
                    <i class="fas fa-times"></i> Cancel
                </a>
                <button type="submit" class="btn btn-success">
                    <i class="fas fa-shopping-cart"></i> Order Sekarang
                </button>
            </div>
        </form>
    </div>
</div>

<script>
// Hapus baris berikut dari form-section alamat:
// - field provinsi, kabupaten/kota, kecamatan, kelurahan, kode pos
// Hapus script JS terkait API wilayah Indonesia

    // Format nomor telepon
    document.getElementById('no_telepon').addEventListener('input', function(e) {
        let value = e.target.value.replace(/\D/g, '');
        if (value.length > 13) {
            value = value.substring(0, 13);
        }
        e.target.value = value;
    });

    // Format kode pos
    document.getElementById('kode_pos').addEventListener('input', function(e) {
        let value = e.target.value.replace(/\D/g, '');
        if (value.length > 5) {
            value = value.substring(0, 5);
        }
        e.target.value = value;
    });
</script>

<?php 
include 'footer.php';
?>