<?php 
include 'header.php';
$kode = mysqli_real_escape_string($conn,$_GET['produk']);
$result = mysqli_query($conn, "SELECT * FROM produk WHERE kode_produk = '$kode'");
$row = mysqli_fetch_assoc($result);
?>

<div class="product-detail-section">
	<div class="container">
		<!-- Breadcrumb -->
		<nav class="breadcrumb-nav">
			<a href="index.php" class="breadcrumb-link">Home</a>
			<span class="breadcrumb-separator">
				<svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
					<polyline points="9,18 15,12 9,6"></polyline>
				</svg>
			</span>
			<span class="breadcrumb-current">Product Detail</span>
		</nav>

		<!-- Product Detail Content -->
		<div class="product-detail-container">
			<!-- Product Image -->
			<div class="product-image-section">
				<div class="product-image-wrapper">
					<img src="image/produk/<?= $row['image']; ?>" alt="<?= $row['nama']; ?>" class="product-image">
				</div>
			</div>

			<!-- Product Info -->
			<div class="product-info-section">
				<form action="proses/add.php" method="GET" class="product-form">
					<input type="hidden" name="kd_cs" value="<?= $kode_cs; ?>">
					<input type="hidden" name="produk" value="<?= $kode; ?>">
					<input type="hidden" name="hal" value="2">
					
					<div class="product-header">
						<h1 class="product-name"><?= $row['nama']; ?></h1>
						<div class="product-price">Rp<?= number_format($row['harga']); ?></div>
						
						<!-- Informasi Stok -->
						<?php 
						$stok = isset($row['stok']) ? $row['stok'] : 0;
						$stok_status = '';
						$stok_class = '';
						if ($stok > 10) {
							$stok_status = 'Tersedia';
							$stok_class = 'stok-available';
						} elseif ($stok > 0) {
							$stok_status = 'Terbatas';
							$stok_class = 'stok-limited';
						} else {
							$stok_status = 'Habis';
							$stok_class = 'stok-out';
						}
						?>
						<div class="product-stock">
							<div class="stock-info">
								<span class="stock-label">Stok:</span>
								<span class="stock-quantity"><?= $stok; ?> unit</span>
								<span class="stock-status <?= $stok_class; ?>"><?= $stok_status; ?></span>
							</div>
						</div>
					</div>

					<div class="product-description">
						<h3 class="section-title">Description</h3>
						<p class="description-text"><?= $row['deskripsi']; ?></p>
					</div>

					<div class="product-options">
						<div class="quantity-section">
							<label for="quantity" class="quantity-label">Quantity</label>
							<div class="quantity-controls">
								<button type="button" class="quantity-btn" onclick="decreaseQuantity()">
									<svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
										<line x1="5" y1="12" x2="19" y2="12"></line>
									</svg>
								</button>
								<input type="number" id="quantity" name="jml" value="1" min="1" class="quantity-input">
								<button type="button" class="quantity-btn" onclick="increaseQuantity()">
									<svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
										<line x1="12" y1="5" x2="12" y2="19"></line>
										<line x1="5" y1="12" x2="19" y2="12"></line>
									</svg>
								</button>
							</div>
						</div>
					</div>

					<div class="product-actions">
						<?php if(isset($_SESSION['user'])){ ?>
							<?php if($stok > 0): ?>
								<button type="submit" class="btn btn-primary btn-large">
									<svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
										<circle cx="9" cy="21" r="1"/>
										<circle cx="20" cy="21" r="1"/>
										<path d="M1 1h4l2.68 13.39a2 2 0 0 0 2 1.61h9.72a2 2 0 0 0 2-1.61L23 6H6"/>
									</svg>
									Add to Cart
								</button>
							<?php else: ?>
								<button type="button" class="btn btn-disabled btn-large" disabled>
									<svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
										<path d="M18.364 18.364A9 9 0 1 1 5.636 5.636a9 9 0 0 1 12.728 12.728zM12 8v4m0 4h.01"/>
									</svg>
									Out of Stock
								</button>
							<?php endif; ?>
						<?php } else { ?>
							<?php if($stok > 0): ?>
								<a href="keranjang.php" class="btn btn-primary btn-large">
									<svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
										<circle cx="9" cy="21" r="1"/>
										<circle cx="20" cy="21" r="1"/>
										<path d="M1 1h4l2.68 13.39a2 2 0 0 0 2 1.61h9.72a2 2 0 0 0 2-1.61L23 6H6"/>
									</svg>
									Add to Cart
								</a>
							<?php else: ?>
								<button type="button" class="btn btn-disabled btn-large" disabled>
									<svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
										<path d="M18.364 18.364A9 9 0 1 1 5.636 5.636a9 9 0 0 1 12.728 12.728zM12 8v4m0 4h.01"/>
									</svg>
									Out of Stock
								</button>
							<?php endif; ?>
						<?php } ?>
						
						<a href="index.php" class="btn btn-outline btn-large">
							<svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
								<path d="M19 12H5M12 19l-7-7 7-7"/>
							</svg>
							Continue Shopping
						</a>
					</div>
				</form>
			</div>
		</div>
	</div>
</div>

<style>
.product-detail-section {
	padding: 2rem 0 4rem;
	background: #fafafa;
	min-height: 100vh;
}

.container {
	max-width: 1200px;
	margin: 0 auto;
	padding: 0 1rem;
}

/* Breadcrumb */
.breadcrumb-nav {
	display: flex;
	align-items: center;
	gap: 0.5rem;
	margin-bottom: 2rem;
	padding: 1rem 0;
}

.breadcrumb-link {
	color: #6b7280;
	text-decoration: none;
	font-size: 14px;
	transition: color 0.2s ease;
}

.breadcrumb-link:hover {
	color: #2563eb;
}

.breadcrumb-separator {
	color: #9ca3af;
}

.breadcrumb-current {
	color: #1f2937;
	font-weight: 500;
	font-size: 14px;
}

/* Product Detail Container */
.product-detail-container {
	display: grid;
	grid-template-columns: 1fr 1fr;
	gap: 3rem;
	background: white;
	border-radius: 16px;
	padding: 2rem;
	box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
}

/* Product Image */
.product-image-section {
	position: sticky;
	top: 2rem;
	height: fit-content;
}

.product-image-wrapper {
	position: relative;
	width: 100%;
	border-radius: 12px;
	overflow: hidden;
	background: #f8f9fa;
}

.product-image {
	width: 100%;
	height: auto;
	display: block;
	transition: transform 0.3s ease;
}

.product-image:hover {
	transform: scale(1.02);
}

/* Product Info */
.product-info-section {
	display: flex;
	flex-direction: column;
}

.product-form {
	height: 100%;
	display: flex;
	flex-direction: column;
	gap: 2rem;
}

.product-header {
	border-bottom: 1px solid #e5e7eb;
	padding-bottom: 1.5rem;
}

.product-name {
	font-size: 2rem;
	font-weight: 700;
	color: #1a1a1a;
	margin: 0 0 1rem 0;
	line-height: 1.3;
}

.product-price {
	font-size: 2.5rem;
	font-weight: 800;
	color: #2563eb;
	margin: 0 0 1rem 0;
}

/* Stok Styles */
.product-stock {
	margin-bottom: 1rem;
	padding: 1rem;
	background: #f8f9fa;
	border-radius: 8px;
	border-left: 4px solid #e9ecef;
}

.stock-info {
	display: flex;
	align-items: center;
	gap: 0.75rem;
	flex-wrap: wrap;
}

.stock-label {
	font-weight: 600;
	color: #495057;
	font-size: 1rem;
}

.stock-quantity {
	font-weight: 700;
	color: #1a1a1a;
	font-size: 1rem;
}

.stock-status {
	padding: 0.375rem 1rem;
	border-radius: 25px;
	font-size: 0.875rem;
	font-weight: 600;
	text-transform: uppercase;
	letter-spacing: 0.5px;
}

.stok-available {
	background: #d4edda;
	color: #155724;
	border: 1px solid #c3e6cb;
}

.stok-limited {
	background: #fff3cd;
	color: #856404;
	border: 1px solid #ffeaa7;
}

.stok-out {
	background: #f8d7da;
	color: #721c24;
	border: 1px solid #f5c6cb;
}

.product-description {
	flex: 1;
}

.section-title {
	font-size: 1.125rem;
	font-weight: 600;
	color: #1f2937;
	margin: 0 0 1rem 0;
}

.description-text {
	color: #6b7280;
	line-height: 1.6;
	margin: 0;
	font-size: 1rem;
}

/* Quantity Section */
.product-options {
	padding: 1.5rem 0;
}

.quantity-section {
	display: flex;
	align-items: center;
	gap: 1rem;
}

.quantity-label {
	font-weight: 500;
	color: #374151;
	font-size: 1rem;
}

.quantity-controls {
	display: flex;
	align-items: center;
	border: 1px solid #d1d5db;
	border-radius: 8px;
	overflow: hidden;
}

.quantity-btn {
	display: flex;
	align-items: center;
	justify-content: center;
	width: 40px;
	height: 40px;
	background: #f9fafb;
	border: none;
	cursor: pointer;
	transition: all 0.2s ease;
}

.quantity-btn:hover {
	background: #e5e7eb;
}

.quantity-input {
	width: 80px;
	height: 40px;
	border: none;
	text-align: center;
	font-size: 1rem;
	font-weight: 500;
	background: white;
	-moz-appearance: textfield;
}

.quantity-input::-webkit-outer-spin-button,
.quantity-input::-webkit-inner-spin-button {
	-webkit-appearance: none;
	margin: 0;
}

.quantity-input:focus {
	outline: none;
}

/* Product Actions */
.product-actions {
	display: flex;
	gap: 1rem;
	margin-top: auto;
}

.btn {
	display: inline-flex;
	align-items: center;
	justify-content: center;
	gap: 0.5rem;
	padding: 0.75rem 1.5rem;
	font-size: 1rem;
	font-weight: 500;
	text-decoration: none;
	border-radius: 8px;
	transition: all 0.2s ease;
	border: none;
	cursor: pointer;
	flex: 1;
	text-align: center;
}

.btn-large {
	padding: 1rem 2rem;
	font-size: 1.125rem;
}

.btn-primary {
	background: linear-gradient(135deg, #2563eb 0%, #1d4ed8 100%);
	color: white;
}

.btn-primary:hover {
	background: linear-gradient(135deg, #1d4ed8 0%, #1e40af 100%);
	transform: translateY(-2px);
	box-shadow: 0 8px 20px rgba(37, 99, 235, 0.3);
}

.btn-outline {
	background: transparent;
	color: #374151;
	border: 1px solid #d1d5db;
}

.btn-outline:hover {
	background: #f9fafb;
	border-color: #9ca3af;
}

.btn-disabled {
	background: #6c757d;
	color: white;
	cursor: not-allowed;
	opacity: 0.6;
}

.btn-disabled:hover {
	background: #6c757d;
	transform: none;
	box-shadow: none;
}

/* Responsive Design */
@media (max-width: 768px) {
	.product-detail-container {
		grid-template-columns: 1fr;
		gap: 2rem;
		padding: 1.5rem;
	}
	
	.product-name {
		font-size: 1.5rem;
	}
	
	.product-price {
		font-size: 2rem;
	}
	
	.product-actions {
		flex-direction: column;
	}
	
	.btn {
		flex: none;
	}
	
	.quantity-section {
		flex-direction: column;
		align-items: flex-start;
		gap: 0.5rem;
	}
}

@media (max-width: 480px) {
	.container {
		padding: 0 0.75rem;
	}
	
	.product-detail-container {
		padding: 1rem;
	}
	
	.product-name {
		font-size: 1.25rem;
	}
	
	.product-price {
		font-size: 1.75rem;
	}
}

/* Loading Animation */
@keyframes fadeIn {
	from {
		opacity: 0;
		transform: translateY(20px);
	}
	to {
		opacity: 1;
		transform: translateY(0);
	}
}

.product-detail-container {
	animation: fadeIn 0.6s ease forwards;
}
</style>

<script>
function increaseQuantity() {
	const input = document.getElementById('quantity');
	const currentValue = parseInt(input.value);
	input.value = currentValue + 1;
}

function decreaseQuantity() {
	const input = document.getElementById('quantity');
	const currentValue = parseInt(input.value);
	if (currentValue > 1) {
		input.value = currentValue - 1;
	}
}
</script>

<?php 
include 'footer.php';
?>