<?php
include 'header.php';
// Start session

// Generate customer code if not exists
if (!isset($_SESSION['kd_cs'])) {
    $kode_cs = 'CS' . date('YmdHis') . rand(100, 999);
    $_SESSION['kd_cs'] = $kode_cs;
} else {
    $kode_cs = $_SESSION['kd_cs'];
}

// Handle AJAX requests
if (isset($_POST['action'])) {
    header('Content-Type: application/json');
    
    if ($_POST['action'] == 'add_to_cart') {
        $produk_id = $_POST['produk_id'];
        $kd_cs = $_POST['kd_cs'];
        $qty = isset($_POST['qty']) ? $_POST['qty'] : 1;
        
        // Check if product exists
        $check_product = mysqli_query($conn, "SELECT * FROM produk WHERE kode_produk = '$produk_id'");
        
        if (mysqli_num_rows($check_product) > 0) {
            $product = mysqli_fetch_assoc($check_product);
            
            // Check if item already in cart
            $check_cart = mysqli_query($conn, "SELECT * FROM keranjang WHERE kode_produk = '$produk_id' AND kode_customer = '$kd_cs'");
            
            if (mysqli_num_rows($check_cart) > 0) {
                // Update quantity
                $update = mysqli_query($conn, "UPDATE keranjang SET qty = qty + $qty WHERE kode_produk = '$produk_id' AND kode_customer = '$kd_cs'");
                echo json_encode(['success' => true, 'message' => 'Quantity updated in cart']);
            } else {
                // Add new item
                $insert = mysqli_query($conn, "INSERT INTO keranjang (kode_produk, kode_customer, qty) VALUES ('$produk_id', '$kd_cs', $qty)");
                echo json_encode(['success' => true, 'message' => 'Product added to cart']);
            }
        } else {
            echo json_encode(['success' => false, 'message' => 'Product not found']);
        }
        exit;
    }
    
    if ($_POST['action'] == 'get_cart_count') {
        $kd_cs = $_POST['kd_cs'];
        $result = mysqli_query($conn, "SELECT SUM(qty) as total FROM keranjang WHERE kode_customer = '$kd_cs'");
        $row = mysqli_fetch_assoc($result);
        echo json_encode(['count' => $row['total'] ?? 0]);
        exit;
    }
}

// Get cart count
$cart_count = 0;
$cart_result = mysqli_query($conn, "SELECT SUM(qty) as total FROM keranjang WHERE kode_customer = '$kode_cs'");
if ($cart_result && mysqli_num_rows($cart_result) > 0) {
    $cart_row = mysqli_fetch_assoc($cart_result);
    $cart_count = $cart_row['total'] ?? 0;
}

// Get featured products
$featured_products = mysqli_query($conn, "SELECT * FROM produk ORDER BY RAND() LIMIT 6");

// Get all categories
$categories = mysqli_query($conn, "SELECT DISTINCT kategori FROM produk WHERE kategori IS NOT NULL AND kategori != ''");

// Search functionality
$search_query = '';
$products_query = "SELECT * FROM produk";
if (isset($_GET['search']) && !empty($_GET['search'])) {
    $search_query = mysqli_real_escape_string($conn, $_GET['search']);
    $products_query .= " WHERE nama LIKE '%$search_query%' OR kategori LIKE '%$search_query%'";
}

// Category filter
if (isset($_GET['kategori']) && !empty($_GET['kategori'])) {
    $kategori = mysqli_real_escape_string($conn, $_GET['kategori']);
    if (strpos($products_query, 'WHERE') !== false) {
        $products_query .= " AND kategori = '$kategori'";
    } else {
        $products_query .= " WHERE kategori = '$kategori'";
    }
}

$products_query .= " ORDER BY nama ASC";
// Ambil produk untuk ditampilkan (limit 4 saja)
$products_query .= " LIMIT 4";
$all_products = mysqli_query($conn, $products_query);
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Warung Bagas - Kebutuhan Sembako Terlengkap</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
            line-height: 1.6;
            color: #1a1a1a;
            background: #fafafa;
        }

        /* Header */
        .header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 2rem 0;
            position: sticky;
            top: 0;
            z-index: 100;
            box-shadow: 0 6px 30px rgba(0,0,0,0.2);
        }

        .nav-container {
            max-width: 1200px;
            margin: 0 auto;
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 0 2rem;
        }

        .logo {
            font-size: 2.6rem;
            font-weight: 700;
            color: white;
            text-decoration: none;
            text-shadow: 2px 2px 4px rgba(0,0,0,0.2);
            letter-spacing: 1px;
        }

        .nav-menu {
            display: flex;
            gap: 3rem;
            list-style: none;
            align-items: center;
        }

        .nav-menu a {
            color: white;
            text-decoration: none;
            font-weight: 600;
            font-size: 1.3rem;
            transition: all 0.3s ease;
            padding: 0.8rem 1.5rem;
            border-radius: 10px;
            letter-spacing: 0.5px;
        }

        .nav-menu a:hover {
            background: rgba(255,255,255,0.15);
            transform: translateY(-3px);
            box-shadow: 0 4px 15px rgba(0,0,0,0.2);
        }

        .cart-icon {
            position: relative;
            font-size: 2.2rem;
            cursor: pointer;
            padding: 0.8rem;
            border-radius: 10px;
            transition: all 0.3s ease;
        }

        .cart-icon:hover {
            background: rgba(255,255,255,0.15);
            transform: translateY(-3px);
            box-shadow: 0 4px 15px rgba(0,0,0,0.2);
        }

        .cart-count {
            position: absolute;
            top: -12px;
            right: -12px;
            background: #ff4757;
            color: white;
            border-radius: 50%;
            width: 28px;
            height: 28px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1rem;
            font-weight: 600;
            box-shadow: 0 3px 10px rgba(255, 71, 87, 0.4);
        }

        /* Search Bar */
        .search-container {
            background: white;
            padding: 1.5rem 0;
            border-bottom: 1px solid #eee;
            box-shadow: 0 3px 15px rgba(0,0,0,0.08);
        }

        .search-form {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 2rem;
            display: flex;
            gap: 1.5rem;
            align-items: center;
        }

        .search-input {
            flex: 1;
            padding: 1.2rem 1.5rem;
            border: 2px solid #e5e7eb;
            border-radius: 12px;
            font-size: 1.2rem;
            transition: all 0.3s ease;
        }

        .search-input:focus {
            outline: none;
            border-color: #667eea;
            box-shadow: 0 0 0 4px rgba(102, 126, 234, 0.15);
        }

        .search-btn {
            padding: 1.2rem 2.5rem;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            border-radius: 12px;
            cursor: pointer;
            font-weight: 600;
            font-size: 1.2rem;
            transition: all 0.3s ease;
            box-shadow: 0 5px 20px rgba(102, 126, 234, 0.3);
        }

        .search-btn:hover {
            transform: translateY(-4px);
            box-shadow: 0 8px 25px rgba(102, 126, 234, 0.4);
        }

        .category-filter {
            padding: 1.2rem 1.5rem;
            border: 2px solid #e5e7eb;
            border-radius: 12px;
            font-size: 1.2rem;
            background: white;
            min-width: 180px;
            transition: all 0.3s ease;
        }

        .category-filter:focus {
            outline: none;
            border-color: #667eea;
            box-shadow: 0 0 0 4px rgba(102, 126, 234, 0.15);
        }

        /* Hero Section */
        .hero {
            background: linear-gradient(135deg, rgba(102, 126, 234, 0.8), rgba(118, 75, 162, 0.8)),
                        url('image/home/wargascuy.jpeg');
            background-size: cover;
            background-position: center;
            background-attachment: fixed;
            color: white;
            padding: 6rem 0;
            text-align: center;
            position: relative;
            overflow: hidden;
        }

        .hero::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0,0,0,0.3);
        }

        .hero-content {
            max-width: 800px;
            margin: 0 auto;
            padding: 0 2rem;
            position: relative;
            z-index: 2;
        }

        .hero h1 {
            font-size: 3.5rem;
            font-weight: 800;
            margin-bottom: 1rem;
            text-shadow: 2px 2px 4px rgba(0,0,0,0.3);
            animation: fadeInUp 1s ease;
        }

        .hero p {
            font-size: 1.3rem;
            margin-bottom: 2rem;
            opacity: 0.95;
            animation: fadeInUp 1s ease 0.2s both;
        }

        .cta-button {
            display: inline-block;
            background: linear-gradient(135deg, #38ef7d 0%, #11998e 100%);
            color: white;
            padding: 1rem 2.5rem;
            border-radius: 50px;
            text-decoration: none;
            font-weight: 600;
            font-size: 1.1rem;
            transition: all 0.3s ease;
            box-shadow: 0 4px 15px rgba(56, 239, 125, 0.4);
            animation: fadeInUp 1s ease 0.4s both;
        }

        .cta-button:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 25px rgba(56, 239, 125, 0.6);
        }

        /* Features Section */
        .features {
            padding: 5rem 0;
            background: white;
        }

        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 2rem;
        }

        .features-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 2rem;
            margin-top: 3rem;
        }

        .feature-card {
            background: white;
            padding: 2rem;
            border-radius: 15px;
            text-align: center;
            box-shadow: 0 5px 20px rgba(0,0,0,0.08);
            transition: transform 0.3s ease;
            border: 1px solid rgba(0,0,0,0.05);
        }

        .feature-card:hover {
            transform: translateY(-5px);
        }

        .feature-icon {
            width: 70px;
            height: 70px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 1rem;
            font-size: 2rem;
        }

        .section-title {
            font-size: 2.5rem;
            font-weight: 700;
            text-align: center;
            margin-bottom: 1rem;
            color: #1a1a1a;
        }

        .section-subtitle {
            text-align: center;
            font-size: 1.1rem;
            color: #666;
            max-width: 600px;
            margin: 0 auto;
        }

        /* About Section */
        .about {
            padding: 5rem 0;
            background: linear-gradient(135deg, #f8f9ff 0%, #e8f2ff 100%);
        }

        .about-content {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 4rem;
            align-items: center;
        }

        .about-text {
            padding: 2rem;
        }

        .about-text h2 {
            font-size: 2.2rem;
            font-weight: 700;
            margin-bottom: 1.5rem;
            color: #1a1a1a;
        }

        .about-text p {
            font-size: 1.1rem;
            color: #555;
            margin-bottom: 1.5rem;
            line-height: 1.8;
        }

        .about-image {
            position: relative;
            border-radius: 15px;
            overflow: hidden;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
        }

        .about-image img {
            width: 100%;
            height: 400px;
            object-fit: cover;
        }

        /* Products Section */
        .products {
            padding: 5rem 0;
            background: white;
        }

        .products-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
            gap: 2rem;
            margin-top: 3rem;
        }

        .product-card {
            background: white;
            border-radius: 15px;
            overflow: hidden;
            box-shadow: 0 5px 25px rgba(0,0,0,0.08);
            transition: all 0.3s ease;
            border: 1px solid rgba(0,0,0,0.05);
            position: relative;
        }

        .product-card:hover {
            transform: translateY(-8px);
            box-shadow: 0 15px 40px rgba(0,0,0,0.15);
        }

        .product-image {
            width: 100%;
            height: 200px;
            position: relative;
            overflow: hidden;
        }

        .product-image img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            transition: transform 0.3s ease;
        }

        .product-card:hover .product-image img {
            transform: scale(1.05);
        }

        .product-badge {
            position: absolute;
            top: 10px;
            right: 10px;
            background: linear-gradient(135deg, #38ef7d 0%, #11998e 100%);
            color: white;
            padding: 4px 8px;
            border-radius: 12px;
            font-size: 0.8rem;
            font-weight: 600;
        }

        .product-info {
            padding: 1.5rem;
        }

        .product-info h3 {
            font-size: 1.2rem;
            font-weight: 600;
            margin-bottom: 0.5rem;
            color: #1a1a1a;
        }

        .product-category {
            color: #666;
            font-size: 0.9rem;
            margin-bottom: 1rem;
        }

        .product-price {
            font-size: 1.3rem;
            font-weight: 700;
            color: #2563eb;
            margin-bottom: 1rem;
        }

        .product-buttons {
            display: flex;
            gap: 0.5rem;
        }

        .btn {
            flex: 1;
            padding: 0.8rem 1rem;
            border: none;
            border-radius: 8px;
            font-weight: 500;
            cursor: pointer;
            transition: all 0.3s ease;
            text-decoration: none;
            text-align: center;
            font-size: 0.9rem;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 0.5rem;
        }

        .btn-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
        }

        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(102, 126, 234, 0.4);
        }

        .btn-outline {
            background: transparent;
            color: #667eea;
            border: 2px solid #667eea;
        }

        .btn-outline:hover {
            background: #667eea;
            color: white;
        }

        .btn:disabled {
            opacity: 0.6;
            cursor: not-allowed;
        }

        /* Toast Notification */
        .toast {
            position: fixed;
            top: 20px;
            right: 20px;
            background: linear-gradient(135deg, #38ef7d 0%, #11998e 100%);
            color: white;
            padding: 1rem 1.5rem;
            border-radius: 8px;
            font-weight: 500;
            z-index: 1000;
            transform: translateX(100%);
            transition: transform 0.3s ease;
        }

        .toast.show {
            transform: translateX(0);
        }

        .toast.error {
            background: linear-gradient(135deg, #ff4757 0%, #ff3742 100%);
        }

   

        /* Animations */
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .fade-in {
            animation: fadeInUp 0.8s ease;
        }

        /* Loading Spinner */
        .loading {
            display: inline-block;
            width: 20px;
            height: 20px;
            border: 3px solid #f3f3f3;
            border-top: 3px solid #667eea;
            border-radius: 50%;
            animation: spin 1s linear infinite;
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        /* Responsive */
        @media (max-width: 768px) {
            .hero h1 {
                font-size: 2.5rem;
            }
            
            .hero p {
                font-size: 1.1rem;
            }
            
            .nav-menu {
                display: none;
            }
            
            .about-content {
                grid-template-columns: 1fr;
                gap: 2rem;
            }
            
            .section-title {
                font-size: 2rem;
            }

            .search-form {
                flex-direction: column;
                gap: 1rem;
            }
        }
    </style>
</head>
<body>

    <!-- Search Section -->
    

    <!-- Hero Section -->
    <section class="hero" id="home">
        <div class="hero-content">
            <h1>Warung Bagas</h1>
            <p>Solusi terpercaya untuk kebutuhan sembako harian Anda sejak 2019. Produk segar, harga terjangkau, pelayanan ramah!</p>
            <a href="#products" class="cta-button">Lihat Produk Kami</a>
        </div>
    </section>

    <!-- Features Section -->
    <section class="features">
        <div class="container">
            <h2 class="section-title">Mengapa Memilih Warung Bagas?</h2>
            <p class="section-subtitle">Kami berkomitmen memberikan pelayanan terbaik untuk kebutuhan harian Anda</p>
            
            <div class="features-grid">
                <div class="feature-card fade-in">
                    <div class="feature-icon">
                        <i class="fas fa-shopping-basket"></i>
                    </div>
                    <h3>Produk Berkualitas</h3>
                    <p>Semua produk dipilih dengan kualitas terbaik dan selalu dalam kondisi segar</p>
                </div>
                <div class="feature-card fade-in">
                    <div class="feature-icon">
                        <i class="fas fa-tags"></i>
                    </div>
                    <h3>Harga Terjangkau</h3>
                    <p>Kami menawarkan harga yang kompetitif untuk semua kalangan masyarakat</p>
                </div>
                <div class="feature-card fade-in">
                    <div class="feature-icon">
                        <i class="fas fa-heart"></i>
                    </div>
                    <h3>Pelayanan Ramah</h3>
                    <p>Tim kami siap melayani Anda dengan ramah dan profesional</p>
                </div>
            </div>
        </div>
    </section>

    <!-- About Section -->
    <section class="about" id="about">
        <style>
            .about {
                background: linear-gradient(135deg, #e0f7fa 0%, #e1bee7 100%);
                padding: 5rem 0 4rem 0;
            }
            .about-main-index {
                display: flex;
                flex-wrap: wrap;
                align-items: center;
                justify-content: center;
                gap: 40px;
                max-width: 1200px;
                margin: 0 auto;
                padding: 0 20px;
            }
            .about-left-index {
                flex: 1 1 350px;
                background: rgba(255,255,255,0.97);
                border-radius: 18px;
                box-shadow: 0 8px 32px rgba(80,80,160,0.10);
                padding: 48px 40px 40px 40px;
                min-width: 320px;
                max-width: 540px;
            }
            .about-title-index {
                color: #764ba2;
                font-size: 2.2rem;
                font-weight: 700;
                margin-bottom: 18px;
                border-bottom: 4px solid #38ef7d;
                padding-bottom: 8px;
            }
            .about-desc-index {
                color: #22223b;
                font-size: 1.08rem;
                line-height: 1.7;
                margin-bottom: 28px;
            }
            .about-features-index {
                display: flex;
                flex-wrap: wrap;
                gap: 18px 32px;
                margin-bottom: 10px;
            }
            .feature-index {
                display: flex;
                align-items: center;
                gap: 10px;
                font-size: 1.01rem;
                color: #444;
                background: #e3fcec;
                border-radius: 8px;
                padding: 7px 16px 7px 10px;
                box-shadow: 0 2px 8px rgba(80,80,160,0.04);
            }
            .feature-icon-index {
                font-size: 1.2rem;
                color: #764ba2;
            }
            .about-right-index {
                flex: 1 1 350px;
                display: flex;
                align-items: center;
                justify-content: center;
                min-width: 320px;
                max-width: 540px;
            }
            .about-img-index {
                width: 100%;
                max-width: 420px;
                border-radius: 22px;
                box-shadow: 
                    0 8px 32px rgba(80,80,160,0.13),
                    0 20px 60px rgba(118, 75, 162, 0.3),
                    0 0 0 20px rgba(118, 75, 162, 0.1),
                    0 0 0 40px rgba(118, 75, 162, 0.05);
                object-fit: cover;
                background: #eee;
                position: relative;
                z-index: 2;
            }
            
            .about-img-index::before {
                content: '';
                position: absolute;
                top: 20px;
                left: 20px;
                right: -20px;
                bottom: -20px;
                background: linear-gradient(135deg, rgba(118, 75, 162, 0.2), rgba(102, 126, 234, 0.2));
                border-radius: 22px;
                z-index: -1;
                filter: blur(15px);
            }
            @media (max-width: 900px) {
                .about-main-index { flex-direction: column; gap: 32px; }
                .about-left-index, .about-right-index { max-width: 100%; }
            }
        </style>
        <div class="about-main-index">
            <div class="about-left-index">
                <div class="about-title-index">Tentang Warung Bagas</div>
                <div class="about-desc-index">
                    WARUNG BAGAS berdiri sejak tahun 2019 sebagai usaha keluarga yang melayani kebutuhan sembako harian masyarakat sekitar. Sejak awal, kami berkomitmen menyediakan berbagai kebutuhan pokok dengan harga terjangkau, produk yang selalu segar, dan pelayanan yang ramah.<br><br>
                    Dengan pengalaman lebih dari 5 tahun, kami telah menjadi pilihan utama masyarakat untuk memenuhi kebutuhan sehari-hari. Kepercayaan pelanggan adalah prioritas utama kami.
                </div>
                <div class="about-features-index">
                    <div class="feature-index"><span class="feature-icon-index">💰</span>Harga Terjangkau</div>
                    <div class="feature-index"><span class="feature-icon-index">🥚</span>Produk Selalu Segar</div>
                    <div class="feature-index"><span class="feature-icon-index">🤝</span>Pelayanan Ramah</div>
                    <div class="feature-index"><span class="feature-icon-index">🕒</span>Buka 24 Jam</div>
                    <div class="feature-index"><span class="feature-icon-index">📦</span>Pemesanan Online</div>
                </div>
            </div>
            <div class="about-right-index">
                <img src="image/home/wargascuy.jpeg" alt="Warung Bagas" class="about-img-index" onerror="this.src='https://via.placeholder.com/420x320?text=Warung+Bagas';">
            </div>
        </div>
    </section>

    <!-- Products Section -->
    <section class="products" id="products">
        <div class="container">
            <h2 class="section-title">Produk Kami</h2>
            <p class="section-subtitle">Berbagai kebutuhan sembako berkualitas untuk keluarga Anda</p>
            
            <div class="products-grid">
                <?php if (mysqli_num_rows($all_products) > 0): ?>
                    <?php while ($row = mysqli_fetch_assoc($all_products)): ?>
                        <div class="product-card">
                            <div class="product-image">
                                <img src="image/produk/<?= $row['image'] ?>" alt="<?= $row['nama'] ?>" 
                                     onerror="this.src='data:image/svg+xml,<svg xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 300 200\'><rect width=\'300\' height=\'200\' fill=\'%23667eea\'/><text x=\'150\' y=\'100\' font-family=\'Arial\' font-size=\'16\' fill=\'white\' text-anchor=\'middle\' dominant-baseline=\'middle\'><?= substr($row['nama'], 0, 20) ?></text></svg>'">
                                <div class="product-badge">New</div>
                            </div>
                            <div class="product-info">
                                <h3><?= htmlspecialchars($row['nama']) ?></h3>
                                <?php if (!empty($row['kategori'])): ?>
                                    <div class="product-category"><?= htmlspecialchars($row['kategori']) ?></div>
                                <?php endif; ?>
                                <div class="product-price">Rp<?= number_format($row['harga'], 0, ',', '.') ?></div>
                                <div class="product-buttons">
                                    <a href="detail_produk.php?produk=<?= $row['kode_produk'] ?>" class="btn btn-outline">
                                        <i class="fas fa-eye"></i> Detail
                                    </a>
                                    <?php if(isset($_SESSION['kd_cs'])){ ?>
							<a href="proses/add.php?produk=<?= $row['kode_produk']; ?>&kd_cs=<?= $kode_cs; ?>&hal=1" class="btn btn-primary">
								<svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
									<circle cx="9" cy="21" r="1"/>
									<circle cx="20" cy="21" r="1"/>
									<path d="M1 1h4l2.68 13.39a2 2 0 0 0 2 1.61h9.72a2 2 0 0 0 2-1.61L23 6H6"/>
								</svg>
								Tambah
							</a>
						<?php } else { ?>
							<a href="keranjang.php" class="btn btn-primary">
								<svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
									<circle cx="9" cy="21" r="1"/>
									<circle cx="20" cy="21" r="1"/>
									<path d="M1 1h4l2.68 13.39a2 2 0 0 0 2 1.61h9.72a2 2 0 0 0 2-1.61L23 6H6"/>
								</svg>
								Tambah
							</a>
						<?php } ?>
                                </div>
                            </div>
                        </div>
                    <?php endwhile; ?>
                <?php else: ?>
                    <div style="grid-column: 1 / -1; text-align: center; padding: 3rem;">
                        <h3>Tidak ada produk yang ditemukan</h3>
                        <p>Silakan coba kata kunci lain atau pilih kategori yang berbeda.</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </section>
<?php
include 'footer.php';
