<?php 
include 'header.php';
if(isset($_POST['submit1'])){
	$id_keranjang = $_POST['id'];
	$qty = $_POST['qty'];

	$edit = mysqli_query($conn, "UPDATE keranjang SET qty = '$qty' where id_keranjang = '$id_keranjang'");
	if($edit){
			echo "
		<script>
		alert('KERANJANG BERHASIL DIPERBARUI');
		window.location = 'keranjang.php';
		</script>
		";
	}
}else if(isset($_GET['del'])){
	$id_keranjang = $_GET['id'];
	$del = mysqli_query($conn, "DELETE FROM keranjang WHERE id_keranjang = '$id_keranjang'");
	if($del){
		echo "
		<script>
		alert('1 PRODUK DIHAPUS');
		window.location = 'keranjang.php';
		</script>
		";
	}
}
?>

<div class="cart-section">
	<div class="container">
		<!-- Header -->
		<div class="cart-header">
			<h1 class="cart-title">Shopping Cart</h1>
			<p class="cart-subtitle">Review your items before checkout</p>
		</div>

		<?php 
		if(isset($_SESSION['user'])){
			$kode_cs = $_SESSION['kd_cs'];
			// CEK JUMLAH KERANJANG
			$cek = mysqli_query($conn, "SELECT * FROM keranjang WHERE kode_customer = '$kode_cs'");
			$jml = mysqli_num_rows($cek);

			if($jml > 0){
				?>
				<div class="cart-content">
					<div class="cart-items">
						<?php 
						if(isset($_SESSION['kd_cs'])){
							$kode_cs = $_SESSION['kd_cs'];
							$result = mysqli_query($conn, "SELECT k.id_keranjang as keranjang, k.kode_produk as kd, k.nama_produk as nama, k.qty as jml, p.image as gambar, p.harga as hrg FROM keranjang k join produk p on k.kode_produk=p.kode_produk WHERE kode_customer = '$kode_cs'");
							$no = 1;
							$hasil = 0;
							while($row = mysqli_fetch_assoc($result)){
						?>
						<div class="cart-item">
							<div class="item-image">
								<img src="image/produk/<?= $row['gambar']; ?>" alt="<?= $row['nama']; ?>">
							</div>
							
							<div class="item-details">
								<h3 class="item-name"><?= $row['nama']; ?></h3>
								<div class="item-price">Rp<?= number_format($row['hrg']); ?></div>
							</div>
							
							<div class="item-quantity">
								<form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="POST" class="quantity-form">
									<input type="hidden" name="id" value="<?php echo $row['keranjang']; ?>">
									<div class="quantity-controls">
										<button type="button" class="qty-btn" onclick="decreaseQty(this)">
											<svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
												<line x1="5" y1="12" x2="19" y2="12"></line>
											</svg>
										</button>
										<input type="number" name="qty" class="qty-input" value="<?= $row['jml']; ?>" min="1" onchange="updateSubtotal(this)">
										<button type="button" class="qty-btn" onclick="increaseQty(this)">
											<svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
												<line x1="12" y1="5" x2="12" y2="19"></line>
												<line x1="5" y1="12" x2="19" y2="12"></line>
											</svg>
										</button>
									</div>
									<button type="submit" name="submit1" class="btn btn-update">Update</button>
								</form>
							</div>
							
							<div class="item-subtotal">
								<div class="subtotal-amount" data-price="<?= $row['hrg']; ?>">
									Rp<?= number_format($row['hrg'] * $row['jml']); ?>
								</div>
							</div>
							
							<div class="item-actions">
								<button type="button" class="btn btn-delete" onclick="deleteItem(<?= $row['keranjang']; ?>)">
									<svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
										<polyline points="3,6 5,6 21,6"></polyline>
										<path d="M19,6V20a2,2 0 0,1 -2,2H7a2,2 0 0,1 -2,-2V6M8,6V4a2,2 0 0,1 2,-2h4a2,2 0 0,1 2,2V6"></path>
									</svg>
								</button>
							</div>
						</div>
						<?php 
								$sub = $row['hrg'] * $row['jml'];
								$hasil += $sub;
								$no++;
							}
						}
						?>
					</div>
					
					<!-- Cart Summary -->
					<div class="cart-summary">
						<div class="summary-card">
							<h3 class="summary-title">Order Summary</h3>
							
							<div class="summary-row">
								<span>Items (<?= $jml; ?>)</span>
								<span class="grand-total">Rp<?= number_format($hasil); ?></span>
							</div>
							
							<div class="summary-row">
								<span>Shipping</span>
								<span class="text-free">FREE</span>
							</div>
							
							<div class="summary-divider"></div>
							
							<div class="summary-row total-row">
								<span>Total</span>
								<span class="total-amount">Rp<?= number_format($hasil); ?></span>
							</div>
							
							<div class="summary-actions">
								<a href="checkout.php?kode_cs=<?= $kode_cs; ?>" class="btn btn-primary btn-checkout">
									<svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
										<path d="M9 12l2 2 4-4"></path>
										<path d="M21 12c-1 0-3-1-3-3s2-3 3-3 3 1 3 3-2 3-3 3"></path>
										<path d="M3 12c1 0 3-1 3-3s-2-3-3-3-3 1-3 3 2 3 3 3"></path>
										<path d="M3 12h6m12 0h-6"></path>
									</svg>
									Proceed to Checkout
								</a>
								<a href="index.php" class="btn btn-outline">Continue Shopping</a>
							</div>
						</div>
					</div>
				</div>
				<?php 
			} else {
				?>
				<div class="empty-cart">
					<div class="empty-cart-icon">
						<svg width="80" height="80" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1">
							<circle cx="9" cy="21" r="1"/>
							<circle cx="20" cy="21" r="1"/>
							<path d="M1 1h4l2.68 13.39a2 2 0 0 0 2 1.61h9.72a2 2 0 0 0 2-1.61L23 6H6"/>
						</svg>
					</div>
					<h3 class="empty-cart-title">Your cart is empty</h3>
					<p class="empty-cart-text">Looks like you haven't added any items to your cart yet.</p>
					<a href="index.php" class="btn btn-primary">Start Shopping</a>
				</div>
				<?php
			}
		} else {
			?>
			<div class="login-required">
				<div class="login-required-icon">
					<svg width="80" height="80" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1">
						<path d="M9 12l2 2 4-4"/>
						<path d="M21 12c-1 0-3-1-3-3s2-3 3-3 3 1 3 3-2 3-3 3"/>
						<path d="M3 12c1 0 3-1 3-3s-2-3-3-3-3 1-3 3 2 3 3 3"/>
						<path d="M3 12h6m12 0h-6"/>
					</svg>
				</div>
				<h3 class="login-required-title">Login Required</h3>
				<p class="login-required-text">Please login to your account before you can add items to your cart.</p>
				<a href="login.php" class="btn btn-primary">Login Now</a>
			</div>
			<?php
		}
		?>
	</div>
</div>

<style>
.cart-section {
	padding: 2rem 0 4rem;
	background: #f8fafc;
	min-height: 100vh;
}

.container {
	max-width: 1200px;
	margin: 0 auto;
	padding: 0 1rem;
}

.cart-header {
	text-align: center;
	margin-bottom: 3rem;
}

.cart-title {
	font-size: 2.5rem;
	font-weight: 700;
	color: #1a202c;
	margin: 0 0 0.5rem 0;
}

.cart-subtitle {
	font-size: 1.125rem;
	color: #718096;
	margin: 0;
}

.cart-content {
	display: grid;
	grid-template-columns: 1fr 350px;
	gap: 2rem;
}

.cart-items {
	background: white;
	border-radius: 12px;
	padding: 1.5rem;
	box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
}

.cart-item {
	display: grid;
	grid-template-columns: 100px 1fr auto auto auto;
	gap: 1rem;
	align-items: center;
	padding: 1.5rem 0;
	border-bottom: 1px solid #e2e8f0;
}

.cart-item:last-child {
	border-bottom: none;
}

.item-image img {
	width: 80px;
	height: 80px;
	object-fit: cover;
	border-radius: 8px;
}

.item-details {
	min-width: 0;
}

.item-name {
	font-size: 1.125rem;
	font-weight: 600;
	color: #2d3748;
	margin: 0 0 0.5rem 0;
}

.item-price {
	font-size: 1rem;
	color: #718096;
	font-weight: 500;
}

.item-quantity {
	display: flex;
	flex-direction: column;
	gap: 0.5rem;
}

.quantity-form {
	display: flex;
	flex-direction: column;
	gap: 0.5rem;
}

.quantity-controls {
	display: flex;
	align-items: center;
	border: 1px solid #e2e8f0;
	border-radius: 6px;
	overflow: hidden;
}

.qty-btn {
	display: flex;
	align-items: center;
	justify-content: center;
	width: 32px;
	height: 32px;
	background: #f7fafc;
	border: none;
	cursor: pointer;
	transition: background 0.2s;
}

.qty-btn:hover {
	background: #edf2f7;
}

.qty-input {
	width: 60px;
	height: 32px;
	border: none;
	text-align: center;
	font-weight: 500;
	-moz-appearance: textfield;
}

.qty-input::-webkit-outer-spin-button,
.qty-input::-webkit-inner-spin-button {
	-webkit-appearance: none;
	margin: 0;
}

.btn-update {
	background: #3182ce;
	color: white;
	border: none;
	padding: 0.375rem 0.75rem;
	border-radius: 4px;
	font-size: 0.875rem;
	cursor: pointer;
	transition: background 0.2s;
}

.btn-update:hover {
	background: #2c5282;
}

.item-subtotal {
	text-align: right;
	min-width: 100px;
}

.subtotal-amount {
	font-size: 1.125rem;
	font-weight: 600;
	color: #2d3748;
}

.item-actions {
	display: flex;
	justify-content: center;
}

.btn-delete {
	display: flex;
	align-items: center;
	justify-content: center;
	width: 40px;
	height: 40px;
	background: #fed7d7;
	color: #e53e3e;
	border: none;
	border-radius: 6px;
	cursor: pointer;
	transition: all 0.2s;
}

.btn-delete:hover {
	background: #feb2b2;
	transform: scale(1.05);
}

.cart-summary {
	background: white;
	border-radius: 12px;
	padding: 1.5rem;
	box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
	height: fit-content;
	position: sticky;
	top: 2rem;
}

.summary-card {
	width: 100%;
}

.summary-title {
	font-size: 1.25rem;
	font-weight: 600;
	color: #2d3748;
	margin: 0 0 1rem 0;
}

.summary-row {
	display: flex;
	justify-content: space-between;
	align-items: center;
	margin-bottom: 0.75rem;
}

.text-free {
	color: #38a169;
	font-weight: 500;
}

.summary-divider {
	height: 1px;
	background: #e2e8f0;
	margin: 1rem 0;
}

.total-row {
	font-size: 1.125rem;
	font-weight: 600;
	color: #2d3748;
}

.total-amount {
	font-size: 1.25rem;
	color: #3182ce;
}

.summary-actions {
	display: flex;
	flex-direction: column;
	gap: 0.75rem;
	margin-top: 1.5rem;
}

.btn {
	display: inline-flex;
	align-items: center;
	justify-content: center;
	gap: 0.5rem;
	padding: 0.75rem 1.5rem;
	font-size: 1rem;
	font-weight: 500;
	text-decoration: none;
	border-radius: 8px;
	transition: all 0.2s;
	border: none;
	cursor: pointer;
	text-align: center;
}

.btn-primary {
	background: linear-gradient(135deg, #3182ce 0%, #2c5282 100%);
	color: white;
}

.btn-primary:hover {
	background: linear-gradient(135deg, #2c5282 0%, #2a4365 100%);
	transform: translateY(-1px);
}

.btn-outline {
	background: transparent;
	color: #4a5568;
	border: 1px solid #e2e8f0;
}

.btn-outline:hover {
	background: #f7fafc;
	border-color: #cbd5e0;
}

.btn-checkout {
	padding: 1rem 1.5rem;
	font-size: 1.125rem;
}

.empty-cart,
.login-required {
	text-align: center;
	padding: 4rem 2rem;
	background: white;
	border-radius: 12px;
	box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
}

.empty-cart-icon,
.login-required-icon {
	color: #cbd5e0;
	margin-bottom: 1rem;
}

.empty-cart-title,
.login-required-title {
	font-size: 1.5rem;
	font-weight: 600;
	color: #2d3748;
	margin: 0 0 1rem 0;
}

.empty-cart-text,
.login-required-text {
	color: #718096;
	margin: 0 0 2rem 0;
}

/* Responsive */
@media (max-width: 768px) {
	.cart-content {
		grid-template-columns: 1fr !important;
	}
	.cart-item {
		grid-template-columns: 60px 1fr !important;
		gap: 1rem !important;
	}
	.item-quantity,
	.item-subtotal,
	.item-actions {
		grid-column: 1 / -1;
		margin-top: 1rem;
	}
	.item-quantity {
		flex-direction: row;
		justify-content: space-between;
		align-items: center;
	}
	.item-subtotal {
		text-align: left;
	}
	.cart-title {
		font-size: 2rem;
	}
	.item-image img {
		width: 60px !important;
		height: 60px !important;
	}
}
</style>

<script>
function increaseQty(button) {
	const input = button.parentElement.querySelector('.qty-input');
	const currentValue = parseInt(input.value);
	input.value = currentValue + 1;
	updateSubtotal(input);
}

function decreaseQty(button) {
	const input = button.parentElement.querySelector('.qty-input');
	const currentValue = parseInt(input.value);
	if (currentValue > 1) {
		input.value = currentValue - 1;
		updateSubtotal(input);
	}
}

function updateSubtotal(input) {
	const cartItem = input.closest('.cart-item');
	const subtotalElement = cartItem.querySelector('.subtotal-amount');
	const price = parseInt(subtotalElement.getAttribute('data-price'));
	const qty = parseInt(input.value);
	const subtotal = price * qty;
	
	subtotalElement.textContent = 'Rp' + subtotal.toLocaleString('id-ID');
	updateGrandTotal();
}

function updateGrandTotal() {
	let total = 0;
	document.querySelectorAll('.subtotal-amount').forEach(element => {
		const price = parseInt(element.getAttribute('data-price'));
		const cartItem = element.closest('.cart-item');
		const qty = parseInt(cartItem.querySelector('.qty-input').value);
		total += price * qty;
	});
	
	document.querySelector('.grand-total').textContent = 'Rp' + total.toLocaleString('id-ID');
	document.querySelector('.total-amount').textContent = 'Rp' + total.toLocaleString('id-ID');
}

function deleteItem(id) {
	if (confirm('Are you sure you want to remove this item from your cart?')) {
		window.location.href = 'keranjang.php?del=1&id=' + id;
	}
}
</script>

<?php 
include 'footer.php';
?>