<?php 
	include 'header.php';
?>

<!-- Modern Product Section -->
<div class="product-section">
	<div class="container">
		<div class="section-header">
			<h1 class="section-title">Produk Kami</h1>
			<div class="section-subtitle">Discover our latest collection</div>
		</div>

		<?php 
		// Ambil kategori unik dari database
		$kategori_result = mysqli_query($conn, "SELECT DISTINCT kategori FROM produk");
		$kategori_list = [];
		while($kat = mysqli_fetch_assoc($kategori_result)) {
			$kategori_list[] = $kat['kategori'];
		}
		$selected_kategori = isset($_GET['kategori']) ? $_GET['kategori'] : 'Semua';
		?>

		<div class="category-filter" style="display: flex; justify-content: center; gap: 12px; margin-bottom: 32px; flex-wrap: wrap;">
			<a href="produk.php" class="filter-btn<?= $selected_kategori=='Semua'?' active':''; ?>">Semua</a>
			<?php foreach($kategori_list as $kat): ?>
				<?php $kat_safe = $kat !== null ? $kat : ''; ?>
				<a href="produk.php?kategori=<?= urlencode($kat_safe); ?>" class="filter-btn<?= $selected_kategori==$kat?' active':''; ?>"><?= htmlspecialchars($kat_safe); ?></a>
			<?php endforeach; ?>
		</div>

		<div class="products-grid">
			<?php 
			$query = "SELECT * FROM produk";
			if($selected_kategori != 'Semua') {
				$kat_safe = mysqli_real_escape_string($conn, $selected_kategori);
				$query .= " WHERE kategori = '$kat_safe'";
			}
			$result = mysqli_query($conn, $query);
			while ($row = mysqli_fetch_assoc($result)) {
				// Ambil stok produk dari database
				$kode_produk = $row['kode_produk'];
				$stok_query = "SELECT COALESCE(stok, 0) as stok FROM produk WHERE kode_produk = '$kode_produk'";
				$stok_result = mysqli_query($conn, $stok_query);
				$stok_data = mysqli_fetch_assoc($stok_result);
				$stok = $stok_data['stok'];
				
				// Tentukan status stok
				$stok_status = '';
				$stok_class = '';
				if ($stok > 10) {
					$stok_status = 'Tersedia';
					$stok_class = 'stok-available';
				} elseif ($stok > 0) {
					$stok_status = 'Terbatas';
					$stok_class = 'stok-limited';
				} else {
					$stok_status = 'Habis';
					$stok_class = 'stok-out';
				}
				?>
				<div class="product-card">
					<div class="product-image">
						<img src="image/produk/<?= $row['image']; ?>" alt="<?= $row['nama']; ?>">
						<div class="product-overlay">
							<div class="overlay-actions">
								<a href="detail_produk.php?produk=<?= $row['kode_produk']; ?>" class="btn-overlay btn-detail">
									<svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
										<path d="M2 12C2 12 5 5 12 5C19 5 22 12 22 12C22 12 19 19 12 19C5 19 2 12 2 12Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
										<circle cx="12" cy="12" r="3" stroke="currentColor" stroke-width="2"/>
									</svg>
									Quick View
								</a>
							</div>
						</div>
					</div>
					
					<div class="product-info">
						<h3 class="product-name"><?= $row['nama']; ?></h3>
						<div class="product-price">Rp<?= number_format($row['harga']); ?></div>
						
						<!-- Informasi Stok -->
						<div class="product-stock">
							<div class="stock-info">
								<span class="stock-label">Stok:</span>
								<span class="stock-quantity"><?= $stok; ?> unit</span>
								<span class="stock-status <?= $stok_class; ?>"><?= $stok_status; ?></span>
							</div>
						</div>
						
						<div class="product-actions">
							<a href="detail_produk.php?produk=<?= $row['kode_produk']; ?>" class="btn btn-outline">
								View Details
							</a>
							
							<?php if(isset($_SESSION['kd_cs'])){ ?>
								<?php if($stok > 0): ?>
									<a href="proses/add.php?produk=<?= $row['kode_produk']; ?>&kd_cs=<?= $kode_cs; ?>&hal=1" class="btn btn-primary">
										<svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
											<path d="M9 22C9.55228 22 10 21.5523 10 21C10 20.4477 9.55228 20 9 20C8.44772 20 8 20.4477 8 21C8 21.5523 8.44772 22 9 22Z" stroke="currentColor" stroke-width="2"/>
											<path d="M20 22C20.5523 22 21 21.5523 21 21C21 20.4477 20.5523 20 20 20C19.4477 20 19 20.4477 19 21C19 21.5523 19.4477 22 20 22Z" stroke="currentColor" stroke-width="2"/>
											<path d="M1 1H5L7.68 14.39C7.77144 14.8504 8.02191 15.264 8.38755 15.5583C8.75318 15.8526 9.2107 16.009 9.68 16H19.4C19.8693 16.009 20.3268 15.8526 20.6925 15.5583C21.0581 15.264 21.3086 14.8504 21.4 14.39L23 6H6" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
										</svg>
										Add to Cart
									</a>
								<?php else: ?>
									<button class="btn btn-disabled" disabled>
										<svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
											<path d="M18.364 18.364A9 9 0 1 1 5.636 5.636a9 9 0 0 1 12.728 12.728zM12 8v4m0 4h.01" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
										</svg>
										Out of Stock
									</button>
								<?php endif; ?>
							<?php } else { ?>
								<?php if($stok > 0): ?>
									<a href="keranjang.php" class="btn btn-primary">
										<svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
											<path d="M9 22C9.55228 22 10 21.5523 10 21C10 20.4477 9.55228 20 9 20C8.44772 20 8 20.4477 8 21C8 21.5523 8.44772 22 9 22Z" stroke="currentColor" stroke-width="2"/>
											<path d="M20 22C20.5523 22 21 21.5523 21 21C21 20.4477 20.5523 20 20 20C19.4477 20 19 20.4477 19 21C19 21.5523 19.4477 22 20 22Z" stroke="currentColor" stroke-width="2"/>
											<path d="M1 1H5L7.68 14.39C7.77144 14.8504 8.02191 15.264 8.38755 15.5583C8.75318 15.8526 9.2107 16.009 9.68 16H19.4C19.8693 16.009 20.3268 15.8526 20.6925 15.5583C21.0581 15.264 21.3086 14.8504 21.4 14.39L23 6H6" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
										</svg>
										Add to Cart
									</a>
								<?php else: ?>
									<button class="btn btn-disabled" disabled>
										<svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
											<path d="M18.364 18.364A9 9 0 1 1 5.636 5.636a9 9 0 0 1 12.728 12.728zM12 8v4m0 4h.01" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
										</svg>
										Out of Stock
									</button>
								<?php endif; ?>
							<?php } ?>
						</div>
					</div>
				</div>
				<?php 
			}
			?>
		</div>
	</div>
</div>

<style>
/* Modern Product Section Styles */
.product-section {
	padding: 4rem 0;
	background: #fafafa;
	min-height: 100vh;
}

.container {
	max-width: 1200px;
	margin: 0 auto;
	padding: 0 1rem;
}

.section-header {
	text-align: center;
	margin-bottom: 3rem;
}

.section-title {
	font-size: 2.5rem;
	font-weight: 700;
	color: #1a1a1a;
	margin: 0 0 0.5rem 0;
	letter-spacing: -0.02em;
}

.section-subtitle {
	font-size: 1.1rem;
	color: #666;
	font-weight: 400;
}

.products-grid {
	display: grid;
	grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
	gap: 2rem;
	margin-top: 2rem;
}

.product-card {
	background: white;
	border-radius: 16px;
	overflow: hidden;
	box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
	transition: all 0.3s ease;
	border: 1px solid rgba(0, 0, 0, 0.05);
}

.product-card:hover {
	transform: translateY(-8px);
	box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
}

.product-image {
	position: relative;
	width: 100%;
	height: 280px;
	overflow: hidden;
}

.product-image img {
	width: 100%;
	height: 100%;
	object-fit: cover;
	transition: transform 0.3s ease;
}

.product-card:hover .product-image img {
	transform: scale(1.05);
}

.product-overlay {
	position: absolute;
	top: 0;
	left: 0;
	right: 0;
	bottom: 0;
	background: rgba(0, 0, 0, 0.5);
	display: flex;
	align-items: center;
	justify-content: center;
	opacity: 0;
	transition: opacity 0.3s ease;
}

.product-card:hover .product-overlay {
	opacity: 1;
}

.overlay-actions {
	text-align: center;
}

.btn-overlay {
	display: inline-flex;
	align-items: center;
	gap: 0.5rem;
	padding: 0.75rem 1.5rem;
	background: white;
	color: #1a1a1a;
	text-decoration: none;
	border-radius: 8px;
	font-weight: 500;
	transition: all 0.2s ease;
}

.btn-overlay:hover {
	background: #f8f9fa;
	transform: translateY(-2px);
}

.product-info {
	padding: 1.5rem;
}

.product-name {
	font-size: 1.25rem;
	font-weight: 600;
	color: #1a1a1a;
	margin: 0 0 0.5rem 0;
	line-height: 1.4;
}

.product-price {
	font-size: 1.5rem;
	font-weight: 700;
	color: #2563eb;
	margin-bottom: 1rem;
}

/* Stok Styles */
.product-stock {
	margin-bottom: 1.5rem;
	padding: 0.75rem;
	background: #f8f9fa;
	border-radius: 8px;
	border-left: 4px solid #e9ecef;
}

.stock-info {
	display: flex;
	align-items: center;
	gap: 0.5rem;
	flex-wrap: wrap;
}

.stock-label {
	font-weight: 600;
	color: #495057;
	font-size: 0.9rem;
}

.stock-quantity {
	font-weight: 700;
	color: #1a1a1a;
	font-size: 0.9rem;
}

.stock-status {
	padding: 0.25rem 0.75rem;
	border-radius: 20px;
	font-size: 0.8rem;
	font-weight: 600;
	text-transform: uppercase;
	letter-spacing: 0.5px;
}

.stok-available {
	background: #d4edda;
	color: #155724;
	border: 1px solid #c3e6cb;
}

.stok-limited {
	background: #fff3cd;
	color: #856404;
	border: 1px solid #ffeaa7;
}

.stok-out {
	background: #f8d7da;
	color: #721c24;
	border: 1px solid #f5c6cb;
}

.product-actions {
	display: flex;
	gap: 0.75rem;
}

.btn {
	display: inline-flex;
	align-items: center;
	justify-content: center;
	gap: 0.5rem;
	padding: 0.75rem 1.5rem;
	font-size: 0.875rem;
	font-weight: 500;
	text-decoration: none;
	border-radius: 8px;
	transition: all 0.2s ease;
	border: none;
	cursor: pointer;
	flex: 1;
	text-align: center;
}

.btn-primary {
	background: #2563eb;
	color: white;
}

.btn-primary:hover {
	background: #1d4ed8;
	transform: translateY(-1px);
}

.btn-outline {
	background: transparent;
	color: #2563eb;
	border: 2px solid #2563eb;
}

.btn-outline:hover {
	background: #2563eb;
	color: white;
	transform: translateY(-1px);
}

.btn-disabled {
	background: #6c757d;
	color: white;
	cursor: not-allowed;
	opacity: 0.6;
}

.btn-disabled:hover {
	background: #6c757d;
	transform: none;
}

/* Category Filter Styles */
.category-filter {
	display: flex;
	justify-content: center;
	gap: 12px;
	margin-bottom: 32px;
	flex-wrap: wrap;
}

.filter-btn {
	padding: 0.75rem 1.5rem;
	background: white;
	color: #666;
	text-decoration: none;
	border-radius: 25px;
	font-weight: 500;
	transition: all 0.2s ease;
	border: 2px solid #e9ecef;
}

.filter-btn:hover {
	background: #f8f9fa;
	color: #2563eb;
	border-color: #2563eb;
	transform: translateY(-1px);
}

.filter-btn.active {
	background: #2563eb;
	color: white;
	border-color: #2563eb;
}

/* Responsive Design */
@media (max-width: 768px) {
	.section-title {
		font-size: 2rem;
	}
	.products-grid {
		grid-template-columns: 1fr !important;
		gap: 1rem !important;
	}
	.product-info {
		padding: 1rem;
	}
	.product-name {
		font-size: 1.1rem;
	}
	.product-price {
		font-size: 1.25rem;
	}
	.stock-info {
		flex-direction: column;
		align-items: flex-start;
		gap: 0.25rem;
	}
	.product-image {
		height: 180px !important;
	}
}
</style>

<?php 
	include 'footer.php';
?>