<?php 
include 'header.php';
?>

<style>
.register-container {
    min-height: 100vh;
    background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%);
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 20px;
}

.register-card {
    background: rgba(255, 255, 255, 0.95);
    border-radius: 20px;
    box-shadow: 0 15px 35px rgba(0, 0, 0, 0.1);
    backdrop-filter: blur(10px);
    border: 1px solid rgba(255, 255, 255, 0.2);
    padding: 40px;
    width: 100%;
    max-width: 600px;
}

.register-header {
    text-align: center;
    margin-bottom: 30px;
}

.register-header h2 {
    color: #333;
    font-weight: 700;
    margin-bottom: 10px;
    font-size: 2.2rem;
}

.register-header p {
    color: #666;
    font-size: 0.9rem;
}

.form-group {
    margin-bottom: 20px;
}

.form-group label {
    font-weight: 600;
    color: #333;
    margin-bottom: 8px;
    display: block;
}

.form-control {
    border: 2px solid #e1e5e9;
    border-radius: 12px;
    padding: 12px 15px;
    font-size: 1rem;
    transition: all 0.3s ease;
    background: #f8f9fa;
}

.form-control:focus {
    border-color: #11998e;
    box-shadow: 0 0 0 0.2rem rgba(17, 153, 142, 0.25);
    background: #fff;
}

.btn-register {
    background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%);
    border: none;
    border-radius: 12px;
    padding: 12px 30px;
    font-weight: 600;
    font-size: 1rem;
    color: white;
    transition: all 0.3s ease;
    width: 100%;
    margin-top: 10px;
}

.btn-register:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(17, 153, 142, 0.3);
    color: white;
}

.btn-login {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border: none;
    border-radius: 12px;
    padding: 12px 30px;
    font-weight: 600;
    font-size: 1rem;
    color: white;
    transition: all 0.3s ease;
    width: 100%;
    text-decoration: none;
    display: inline-block;
    text-align: center;
    margin-top: 15px;
}

.btn-login:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(102, 126, 234, 0.3);
    color: white;
    text-decoration: none;
}

.register-divider {
    text-align: center;
    margin: 20px 0;
    position: relative;
}

.register-divider::before {
    content: '';
    position: absolute;
    top: 50%;
    left: 0;
    right: 0;
    height: 1px;
    background: #e1e5e9;
}

.register-divider span {
    background: rgba(255, 255, 255, 0.95);
    padding: 0 15px;
    color: #666;
    font-size: 0.9rem;
}

.input-group {
    position: relative;
}

.input-group .form-control {
    padding-left: 45px;
}

.input-icon {
    position: absolute;
    left: 15px;
    top: 50%;
    transform: translateY(-50%);
    color: #11998e;
    font-size: 1.1rem;
}

@media (max-width: 768px) {
    .register-card {
        padding: 30px 20px;
        margin: 10px;
    }
    
    .register-header h2 {
        font-size: 1.8rem;
    }
}
</style>

<div class="register-container">
    <div class="register-card">
        <div class="register-header">
            <h2>Daftar Akun</h2>
            <p>Buat akun baru untuk mulai berbelanja</p>
        </div>
        
        <form action="proses/register.php" method="POST">
            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="nama">Nama</label>
                        <input type="text" class="form-control" id="nama" placeholder="Nama" name="nama" required>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="email">Email</label>
                        <input type="email" class="form-control" id="email" placeholder="Email" name="email" required>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="username">Username</label>
                        <input type="text" class="form-control" id="username" placeholder="Username" name="username" required >
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="telp">No Telp</label>
                        <input type="text" class="form-control" id="telp" placeholder="+62" name="telp" required >
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="password">Password</label>
                        <input type="password" class="form-control" id="password" placeholder="Password" name="password" required>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="konfirmasi">Konfirmasi Password</label>
                        <input type="password" class="form-control" id="konfirmasi" placeholder="Konfirmasi Password" name="konfirmasi" required>
                    </div>
                </div>
            </div>
            <button type="submit" class="btn btn-register">
                <i class="fas fa-user-plus me-2"></i>Daftar Sekarang
            </button>
            <div class="register-divider">
                <span>sudah punya akun?</span>
            </div>
            <a href="user_login.php" class="btn btn-login">
                <i class="fas fa-sign-in-alt me-2"></i>Login
            </a>
        </form>
    </div>
</div>

<?php 
include 'footer.php';
?>