<?php 
include 'header.php';
?>

<style>
    .success-container {
        min-height: 80vh;
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 2rem 1rem;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        background: linear-gradient(135deg, #f0f9ff 0%, #e0f2fe 100%);
    }
    
    .success-card {
        background: white;
        border-radius: 20px;
        box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
        padding: 3rem 2rem;
        text-align: center;
        max-width: 500px;
        width: 100%;
        border-top: 4px solid #10b981;
        position: relative;
        overflow: hidden;
    }
    
    .success-card::before {
        content: '';
        position: absolute;
        top: -50%;
        left: -50%;
        width: 200%;
        height: 200%;
        background: radial-gradient(circle, rgba(16, 185, 129, 0.05) 0%, transparent 70%);
        animation: rotate 20s linear infinite;
    }
    
    .success-icon {
        width: 120px;
        height: 120px;
        margin: 0 auto 1.5rem;
        background: linear-gradient(135deg, #10b981 0%, #059669 100%);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        position: relative;
        z-index: 2;
        box-shadow: 0 10px 30px rgba(16, 185, 129, 0.3);
        animation: successPulse 2s ease-in-out infinite;
    }
    
    .success-icon::before {
        content: '';
        position: absolute;
        width: 100%;
        height: 100%;
        border-radius: 50%;
        background: linear-gradient(135deg, #10b981 0%, #059669 100%);
        opacity: 0.3;
        animation: ripple 2s ease-out infinite;
    }
    
    .checkmark {
        width: 60px;
        height: 60px;
        position: relative;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    
    .checkmark::before {
        content: '';
        position: absolute;
        width: 35px;
        height: 20px;
        border: 4px solid white;
        border-top: none;
        border-right: none;
        transform: rotate(-45deg);
        animation: drawCheck 1s ease-out 0.5s both;
    }
    
    .success-title {
        font-size: 2.2rem;
        font-weight: 700;
        color: #1e293b;
        margin-bottom: 1rem;
        position: relative;
        z-index: 2;
        animation: fadeInUp 0.8s ease-out 0.3s both;
    }
    
    .success-message {
        font-size: 1.1rem;
        color: #64748b;
        line-height: 1.6;
        margin-bottom: 2rem;
        position: relative;
        z-index: 2;
        animation: fadeInUp 0.8s ease-out 0.5s both;
    }
    
    .store-name {
        color: #f59e0b;
        font-weight: 700;
        text-shadow: 0 2px 4px rgba(245, 158, 11, 0.2);
    }
    
    .btn {
        padding: 0.75rem 2rem;
        border-radius: 12px;
        font-weight: 600;
        text-decoration: none;
        display: inline-flex;
        align-items: center;
        gap: 0.5rem;
        transition: all 0.3s ease;
        margin: 0 0.5rem;
        position: relative;
        z-index: 2;
        animation: fadeInUp 0.8s ease-out 0.7s both;
    }
    
    .btn-primary {
        background: linear-gradient(135deg, #3b82f6 0%, #1d4ed8 100%);
        color: white;
        box-shadow: 0 4px 15px rgba(59, 130, 246, 0.3);
    }
    
    .btn-primary:hover {
        transform: translateY(-3px);
        box-shadow: 0 12px 25px rgba(59, 130, 246, 0.4);
        color: white;
    }
    
    .btn-outline {
        background: transparent;
        border: 2px solid #e5e7eb;
        color: #6b7280;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
    }
    
    .btn-outline:hover {
        background: #f9fafb;
        transform: translateY(-2px);
        box-shadow: 0 8px 20px rgba(0, 0, 0, 0.15);
        color: #374151;
    }
    
    .floating-elements {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        pointer-events: none;
        z-index: 1;
    }
    
    .floating-elements::before,
    .floating-elements::after {
        content: '✓';
        position: absolute;
        font-size: 1.5rem;
        color: rgba(16, 185, 129, 0.2);
        animation: float 6s ease-in-out infinite;
    }
    
    .floating-elements::before {
        top: 20%;
        left: 15%;
        animation-delay: 0s;
    }
    
    .floating-elements::after {
        top: 70%;
        right: 20%;
        animation-delay: 3s;
    }
    
    /* Animations */
    @keyframes successPulse {
        0%, 100% { 
            transform: scale(1);
            box-shadow: 0 10px 30px rgba(16, 185, 129, 0.3);
        }
        50% { 
            transform: scale(1.05);
            box-shadow: 0 15px 40px rgba(16, 185, 129, 0.4);
        }
    }
    
    @keyframes ripple {
        0% {
            transform: scale(1);
            opacity: 0.3;
        }
        100% {
            transform: scale(1.3);
            opacity: 0;
        }
    }
    
    @keyframes drawCheck {
        0% {
            width: 0;
            height: 0;
        }
        50% {
            width: 35px;
            height: 0;
        }
        100% {
            width: 35px;
            height: 20px;
        }
    }
    
    @keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translateY(30px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }
    
    @keyframes rotate {
        from { transform: rotate(0deg); }
        to { transform: rotate(360deg); }
    }
    
    @keyframes float {
        0%, 100% { 
            transform: translateY(0px) rotate(0deg);
            opacity: 0.3;
        }
        50% { 
            transform: translateY(-20px) rotate(180deg);
            opacity: 0.1;
        }
    }
    
    @media (max-width: 768px) {
        .success-card {
            padding: 2rem 1.5rem;
            margin: 1rem;
        }
        
        .success-icon {
            width: 100px;
            height: 100px;
        }
        
        .checkmark::before {
            width: 28px;
            height: 16px;
        }
        
        .success-title {
            font-size: 1.8rem;
        }
        
        .btn {
            display: block;
            margin: 0.5rem 0;
            width: 100%;
            justify-content: center;
        }
    }
</style>

<div class="success-container">
    <div class="success-card">
        <div class="floating-elements"></div>
        
        <div class="success-icon">
            <div class="checkmark"></div>
        </div>
        
        <h1 class="success-title">Checkout Berhasil!</h1>
        
        <p class="success-message">
            Terimakasih sudah berbelanja di <span class="store-name">WARUNG BAGAS</span>! 
            Pesananmu sedang diproses, silahkan tunggu barangmu di rumah ya.. 😊
        </p>
        
        <div style="display: flex; justify-content: center; align-items: center; margin-top: 24px;">
            <a href="index.php" class="btn btn-primary" style="margin: 0 auto;">
                <i class="fas fa-home"></i>
                Kembali ke Beranda
            </a>
        </div>
    </div>
</div>

<script>
// Tambahkan konfetti effect saat halaman dimuat
window.addEventListener('load', function() {
    // Simulasi konfetti dengan elemen checkmark
    const createConfetti = () => {
        const confetti = document.createElement('div');
        confetti.style.position = 'fixed';
        confetti.style.left = Math.random() * 100 + 'vw';
        confetti.style.top = '-10px';
        confetti.style.fontSize = '20px';
        confetti.style.color = '#10b981';
        confetti.style.pointerEvents = 'none';
        confetti.style.zIndex = '9999';
        confetti.innerHTML = '✓';
        confetti.style.animation = 'fall 3s linear forwards';
        
        document.body.appendChild(confetti);
        
        setTimeout(() => {
            confetti.remove();
        }, 3000);
    };
    
    // Buat konfetti secara berkala
    for (let i = 0; i < 10; i++) {
        setTimeout(createConfetti, i * 200);
    }
});

// Tambahkan CSS untuk animasi jatuh konfetti
const style = document.createElement('style');
style.textContent = `
    @keyframes fall {
        from {
            transform: translateY(-100vh) rotate(0deg);
            opacity: 1;
        }
        to {
            transform: translateY(100vh) rotate(360deg);
            opacity: 0;
        }
    }
`;
document.head.appendChild(style);
</script>

<?php 
include 'footer.php';
?>