<?php
session_start();
include 'header.php';
include 'koneksi/koneksi.php';

// Cek apakah user sudah login
if (!isset($_SESSION['kd_cs'])) {
    echo "<script>alert('Silakan login terlebih dahulu!'); window.location='user_login.php';</script>";
    exit;
}

$kode_customer = $_SESSION['kd_cs'];

// Ambil daftar pesanan milik customer ini (group by invoice)
$result = mysqli_query($conn, "SELECT p.invoice, p.tanggal, p.status, p.terima, p.tolak, x.total 
    FROM (SELECT invoice, SUM(qty*harga) as total, MIN(id_order) as min_id FROM produksi WHERE kode_customer = '$kode_customer' GROUP BY invoice) as x 
    JOIN produksi p ON p.invoice = x.invoice AND p.id_order = x.min_id 
    ORDER BY p.tanggal DESC");
?>

<style>
@media (max-width: 768px) {
    .container {
        padding: 0 8px !important;
        max-width: 100% !important;
    }
    table {
        font-size: 0.95rem !important;
        display: block;
        overflow-x: auto;
        width: 100%;
    }
    th, td {
        white-space: nowrap;
    }
}
</style>

<div class="container" style="max-width:900px; margin:40px auto;">
    <h2 style="border-bottom:3px solid #ddd; padding-bottom:10px;">Status Pesanan Saya</h2>
    <br>
    <table class="table table-bordered table-striped">
        <thead>
            <tr>
                <th>Invoice</th>
                <th>Tanggal</th>
                <th>Status</th>
                <th>Total</th>
                <th>Detail</th>
            </tr>
        </thead>
        <tbody>
        <?php while($row = mysqli_fetch_assoc($result)) { ?>
            <tr>
                <td><?= $row['invoice']; ?></td>
                <td><?= $row['tanggal']; ?></td>
                <td>
                    <?php
                    if ($row['terima'] == 1) {
                        echo '<span style="color:green;font-weight:bold;">Diterima</span>';
                    } else if ($row['tolak'] == 1) {
                        echo '<span style="color:red;font-weight:bold;">Ditolak</span>';
                    } else {
                        echo '<span style="color:orange;font-weight:bold;">' . $row['status'] . '</span>';
                    }
                    ?>
                </td>
                <td>Rp.<?= number_format($row['total']); ?></td>
                <td><button class="btn btn-info btn-sm" onclick="showDetailModal('<?= $row['invoice']; ?>')">Detail</button></td>
            </tr>
        <?php } ?>
        </tbody>
    </table>
</div>

<!-- Modal Detail Pesanan -->
<div class="modal fade" id="detailModal" tabindex="-1" role="dialog" aria-labelledby="detailModalLabel">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title" id="detailModalLabel">Detail Pesanan</h4>
      </div>
      <div class="modal-body" id="modalDetailContent">
        Memuat data...
      </div>
    </div>
  </div>
</div>

<script>
function showDetailModal(invoice) {
    $('#modalDetailContent').html('Memuat data...');
    $('#detailModal').modal('show');
    $.get('detail_pesanan_user.php', {inv: invoice}, function(data) {
        $('#modalDetailContent').html(data);
    });
}
</script>

<?php include 'footer.php'; ?> 