<?php 
	include 'header.php';
 ?>

<style>
.login-container {
    min-height: 100vh;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 20px;
}

.login-card {
    background: rgba(255, 255, 255, 0.97);
    border-radius: 28px;
    box-shadow: 0 15px 35px rgba(0, 0, 0, 0.08);
    padding: 40px 20px 32px 20px;
    width: 100%;
    max-width: 320px;
}

.login-header {
    text-align: center;
    margin-bottom: 28px;
}

.login-header h2 {
    color: #333;
    font-weight: 700;
    margin-bottom: 8px;
    font-size: 2rem;
}

.login-header p {
    color: #666;
    font-size: 1rem;
}

.form-group {
    margin-bottom: 22px;
    text-align: center;
}

.form-group label {
    font-weight: 700;
    color: #222;
    margin-bottom: 8px;
    display: block;
    font-size: 1.05rem;
    text-align: center;
}

.input-group {
    position: relative;
    display: flex;
    justify-content: center;
}

.input-group .form-control {
    padding-left: 38px;
    height: 42px;
    font-size: 1rem;
    width: 100%;
    max-width: 220px;
    margin: 0 auto;
    text-align: left;
}

.input-icon {
    position: absolute;
    left: 12px;
    top: 50%;
    transform: translateY(-50%);
    color: #667eea;
    font-size: 1.1rem;
    pointer-events: none;
}

.form-control {
    border: 2px solid #e1e5e9;
    border-radius: 12px;
    background: #f8f9fa;
    transition: all 0.3s;
}

.form-control:focus {
    border-color: #667eea;
    box-shadow: 0 0 0 0.15rem rgba(102, 126, 234, 0.13);
    background: #fff;
}

.btn-login {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border: none;
    border-radius: 14px;
    padding: 12px 0;
    font-weight: 700;
    font-size: 1.05rem;
    color: white;
    transition: all 0.3s;
    width: 100%;
    margin-bottom: 15px;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
}

.btn-login i {
    margin-right: 6px;
    font-size: 1rem;
}

.btn-login:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(102, 126, 234, 0.18);
    color: white;
}

.btn-register {
    background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%);
    border: none;
    border-radius: 14px;
    padding: 12px 0;
    font-weight: 700;
    font-size: 1.05rem;
    color: white;
    transition: all 0.3s;
    width: 100%;
    text-decoration: none;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
}

.btn-register i {
    margin-right: 6px;
    font-size: 1rem;
}

.btn-register:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(17, 153, 142, 0.18);
    color: white;
    text-decoration: none;
}

.login-divider {
    display: flex;
    align-items: center;
    text-align: center;
    margin: 18px 0 14px 0;
}
.login-divider::before, .login-divider::after {
    content: '';
    flex: 1;
    border-bottom: 1.5px solid #e1e5e9;
}
.login-divider:not(:empty)::before {
    margin-right: 8px;
}
.login-divider:not(:empty)::after {
    margin-left: 8px;
}
.login-divider span {
    color: #888;
    font-size: 0.95rem;
    background: rgba(255,255,255,0.97);
    padding: 0 8px;
}

@media (max-width: 400px) {
    .login-card {
        padding: 16px 2px 10px 2px;
        margin: 4px;
        max-width: 98vw;
    }
    .login-header h2 {
        font-size: 1.1rem;
    }
    .input-group .form-control {
        max-width: 98vw;
    }
}
</style>

<div class="login-container">
    <div class="login-card">
        <div class="login-header">
            <h2>Selamat Datang</h2>
            <p>Silakan login untuk melanjutkan</p>
        </div>
        
        <form action="proses/login.php" method="POST">
            <div class="form-group">
                <label for="username">Username</label>
                <div class="input-group">
                    <i class="fas fa-user input-icon"></i>
                    <input type="text" class="form-control" id="username" placeholder="Masukkan username Anda" name="username" required autocomplete="username">
                </div>
            </div>
            
            <div class="form-group">
                <label for="password">Password</label>
                <div class="input-group">
                    <i class="fas fa-lock input-icon"></i>
                    <input type="password" class="form-control" id="password" placeholder="Masukkan password Anda" name="pass" required autocomplete="current-password">
                </div>
            </div>
            
            <button type="submit" class="btn btn-login">
                <i class="fas fa-sign-in-alt"></i>Login
            </button>
            
            <div class="login-divider">
                <span>atau</span>
            </div>
            
            <a href="register.php" class="btn btn-register">
                <i class="fas fa-user-plus"></i>Daftar Akun Baru
            </a>
        </form>
    </div>
</div>

<?php 
	include 'footer.php';
 ?>